function checkFolderCeiling()
{
    if(globalModelID == '')
    {
        globalModelID = createModel(globalModelName);
    }
    var RT = desiteAPI.getRootContainerList(globalModelName);
    var str = '<container ID="'+ globalCeilingFolder +'" name="'+ globalCeilingFolder +'" />';
    desiteAPI.createObjectFromXml(RT,str);
}

function checkContact(p1,p2,pC1,pC2,n,pC1_result,pC2_result,data,id,distance)
{
    var erg1 = pC1_result;
    var erg2 = pC2_result;
    if(!(pC1_result == 1 && pC2_result == 1))
    {
        for(var l = 0; l < data.length; l++)
        {
            if(data[l][2].length > 0 && (data[l][0] != id))
            {
                if((data[l][4][2] <= p1[2] && data[l][4][5] >= p1[2]) ||(data[l][4][2] <= p2[2] && data[l][4][5] >= p2[2]))
                {
                    for(var m = 0; m < data[l][2].length; m++)
                    {
                        var cP0 = data[l][3][data[l][2][m][0]];
                        var cP1 = data[l][3][data[l][2][m][1]];
                        var cP2 = data[l][3][data[l][2][m][2]];
                                        
                        var e1 = rayTriangleIntersection(cP0,cP1,cP2,pC1,n);
                        var e2 = rayTriangleIntersection(cP0,cP1,cP2,pC2,n);

                        if(e1 != null)
                        {
                            if(Math.abs(e1) <= distance)
                            {
                                erg1 = 1;
                            }    
                        }

                        if(e2 != null)
                        {
                            if(Math.abs(e2) <= distance)
                            {
                                erg2 = 1;
                                
                            }
                        }
                                  
                        if(erg1 == 1 && erg2 == 1)
                        {
                            break;
                        }
                    }
                }
                            
                if(erg1 == 1 && erg2 == 1)
                {
                    break;
                }                        
            }
       }
    }
    return [erg1,erg2];
}

function maxDistanceData(pC1,n,data,id)
{
    var d = -1;
    for(var l = 0; l < data.length; l++)
    {
        if(data[l][2].length > 0 && (data[l][0] != id))
        {
            if((data[l][4][0] <= pC1[0] && data[l][4][3] >= pC1[0] && data[l][4][1] <= pC1[1] && data[l][4][4] >= pC1[1]))
            {
                for(var m = 0; m < data[l][2].length; m++)
                {
                    var cP0 = data[l][3][data[l][2][m][0]];
                    var cP1 = data[l][3][data[l][2][m][1]];
                    var cP2 = data[l][3][data[l][2][m][2]];
                    var pL = rayTriangleIntersection(cP0,cP1,cP2,pC1,n);
                    if(d < 0 && pL != null)
                    {
                        if(pL > 0)
                        {
                            d = pL;
                        }
                    }
                    else if(pL != null)
                    {
                        if(pL > 0 && d > pL)
                        {
                            d = pL;
                        }
                    }
                }
            }
        }
    }
    return d;   
}

function checkCeiling4D(process)
{
    for(var a = 0; a < __currentSlabData__.length; a++)
    {
        var polygons = getPolygonsCurrent(a);
        var slabArea = 0;
        var cb1 = true;
        var localArea = 0;
        for(var i = 0; i < polygons.length; i++)
        {
            var polyBB = getPolygonsBB(polygons[i]);
            var openingLiftDone = false;
            var innerDone = false;
            var inner = false;
            if(i == 0)
            {
                slabArea = calcAreaBB(polyBB);
            }
            else
            {
                localArea = calcAreaBB(polyBB);
                inner = true;               
            }
            for(var j = 0; j < polygons[i].length; j++)
            {
                if(openingLiftDone)
                {
                    break;
                }
                var p1;
                var p2;
                if (j == polygons[i].length - 1)
                {
                    p1 = polygons[i][j];
                    p2 = polygons[i][0];
                } 
                else
                {
                    p1 = polygons[i][j];
                    p2 = polygons[i][j+1];
                }
                var dir = [p2[0] - p1[0], p2[1] - p1[1], p2[2] - p1[2]];
                var dir_length_int = parseInt(Math.sqrt(dir[0] * dir[0] + dir[1] * dir[1] + dir[2] * dir[2]) / __dep__[2].value);
                var n;
                var n1 = [-dir[1],dir[0]];
                var n2 = [dir[1],-dir[0]];
                var n1_check = 0;
                var pCheck = [(p2[0] + p1[0]) / 2, (p2[1] + p1[1]) / 2];
                for(var k = 0; k < polygons[i].length; k++)
                {
                    if (k != j)
                    {
                        var pC1;
                        var pC2;
                        if (k == polygons[i].length - 1)
                        {
                            pC1 = polygons[i][k];
                            pC2 = polygons[i][0];
                        } 
                        else
                        {
                            pC1 = polygons[i][k];
                            pC2 = polygons[i][k+1];
                        }
                        var cDir = [pC2[0] - pC1[0], pC2[1] - pC1[1], pC2[2] - pC2[2]];
                        var erg1 = rayLineIntersection_2D(pCheck,n1,pC1,cDir);
                        n1_check = n1_check + erg1;
                        if(!(n1_check % 2))
                        {
                            n = n1;
                        }
                        else
                        {
                            n = n2;
                        }
                    }
                }
                var n_length = norm2_2D(n);
                n[0] = n[0] / n_length;
                n[1] = n[1] / n_length;
                n.push(0);
                var pC1_result = 0;
                var pC2_result = 0;
                var addProp = '';
                var tS = false;
                if(dir_length_int == 0)
                {
                    dir_length_int = 1
                    tS = true;
                }
                for(var k = 0; k < dir_length_int; k++)
                {
                    var pC1_result = 0;
                    var pC2_result = 0;
                    addProp = '';
                    var pC1;
                    if(tS)
                    {
                        pC1 = [p1[0],p1[1],p1[2]];
                        pC2 = [p2[0],p2[1],p2[2]];
                    }
                    else
                    {
                        if(dir_length_int == 0)
                        {
                            pC1 = [p1[0],p1[1],p1[2]]; 
                        } 
                        else
                        {
                            pC1 = [p1[0] + (k/dir_length_int) * dir[0],p1[1] + (k/dir_length_int) * dir[1],p1[2] + (k/dir_length_int) * dir[2]];
                        }
                        var pC2;
                        if(k+1 > dir_length_int)
                        {
                            pC2 = [p2[0],p2[1],p2[2]];
                        }
                        else
                        {
                            pC2 = [p1[0] + ((k+1)/dir_length_int) * dir[0],p1[1] + ((k+1)/dir_length_int) * dir[1], p1[2] + ((k+1)/dir_length_int) * dir[2]];
                        }
                        var dist1 = [pC1[0] - pC2[0], pC1[1] - pC2[1], pC1[2] - pC2[2]]; 
                        if(norm2_3D(dist1) < 10e-9)
                        {
                            continue;
                        }
                    }
                    //Check free Edge
                    var n_div = [n[0],n[1],n[2]];
                    if(i > 0)
                    {
                        n_div[0] = -n[0];
                        n_div[1] = -n[1];
                    }
                    var dist = -1;
                    if(document.getElementById('cb1').checked && cb1)
                    {
                        var nnp = [0,0,0];
                        dist = calculateCurrentMaxDistance(0,0,pC1,pC2,nnp,__currentSlabData__[a][0],inner);
                        if (dist > __dep__[4].value)
                        {
                            cb1 = false;
                        }
                    }
                    dist = -1;
                    var erg = [];
                    if(!(pC1_result == 1 && pC2_result == 1))
                    {
                        erg = checkContact(p1,p2,pC1,pC2,n_div,pC1_result,pC2_result,__legacyGeometryData__,__currentSlabData__[a][0], __dep__[3].value);
                        if(pC1_result == 0)
                        {
                            pC1_result = erg[0];
                        }
                        if(pC2_result == 0)
                        {
                            pC2_result = erg[1];
                        }
                    }
                    if(!(pC1_result == 1 && pC2_result == 1))
                    {
                        erg = checkContact(p1,p2,pC1,pC2,n_div,pC1_result,pC2_result,__legacySlabData__,__currentSlabData__[a][0], __dep__[3].value);
                        if(pC1_result == 0)
                        {
                            pC1_result = erg[0];
                        }
                        if(pC2_result == 0)
                        {
                            pC2_result = erg[1];
                        }
                    }
                    if(!(pC1_result == 1 && pC2_result == 1))
                    {
                        erg = checkContact(p1,p2,pC1,pC2,n_div,pC1_result,pC2_result,__legacyRoofData__,__currentSlabData__[a][0], __dep__[3].value);
                        if(pC1_result == 0)
                        {
                            pC1_result = erg[0];
                        }
                        if(pC2_result == 0)
                        {
                            pC2_result = erg[1];
                        }
                    }
                    if(!(pC1_result == 1 && pC2_result == 1))
                    {
                        erg = checkContact(p1,p2,pC1,pC2,n_div,pC1_result,pC2_result,__globalDTMData__,__currentSlabData__[a][0], __dep__[3].value);
                        if(pC1_result == 0)
                        {
                            pC1_result = erg[0];
                        }
                        if(pC2_result == 0)
                        {
                            pC2_result = erg[1];
                        }
                    }
                    // Check lift
                    if(!((pC1_result == 1 && pC2_result == 1)))
                    {
                        for(var l = 0; l < __globalLiftData__.length;l++)
                        {
                            if(__globalLiftData__[l][4][2] <= p1[2] && __globalLiftData__[l][4][5] >= p1[2])
                            {
                                for(var m = 0; m < __globalLiftData__[l][2].length; m++)
                                {
                                    var cP0 = __globalLiftData__[l][3][__globalLiftData__[l][2][m][0]];
                                    var cP1 = __globalLiftData__[l][3][__globalLiftData__[l][2][m][1]];
                                    var cP2 = __globalLiftData__[l][3][__globalLiftData__[l][2][m][2]];

                                    var e1 = rayTriangleIntersection(cP0,cP1,cP2,pC1,n_div);
                                    var e2 = rayTriangleIntersection(cP0,cP1,cP2,pC2,n_div);

                                    if(e1 != null)
                                    {
                                        if(Math.abs(e1) <= __dep__[6].value)
                                        {
                                            pC1_result = 3;
                                        }    
                                    }

                                    if(e2 != null)
                                    {
                                        if(Math.abs(e2) <= __dep__[6].value)
                                        {
                                            pC2_result = 3;
                                        }
                                    }
                                    if(pC1_result == 3 || pC2_result == 3)
                                    {
                                        if(!openingLiftDone)
                                        {
                                            var bboxData = desiteAPI.getOOBBCommon(__globalLiftData__[l][0]);
                                            var a1 = [bboxData.axis1[0],bboxData.axis1[1],bboxData.axis1[2]];
                                            var a2 = [bboxData.axis2[0],bboxData.axis2[1],bboxData.axis2[2]];
                                            var a3 = [bboxData.axis3[0],bboxData.axis3[1],bboxData.axis3[2]];
                                            var axis1 = [];
                                            var axis2 = [];
                                            var axis3 = [];
                                            if(Math.abs(a1[0])< 10e-6 && Math.abs(a1[1])< 10e-6)
                                            {
                                                axis1 = a2;
                                                axis2 = a3;
                                                axis3 = a1;
                                            }
                                            else if(Math.abs(a2[0])< 10e-6 && Math.abs(a2[1])< 10e-6)
                                            {
                                                axis1 = a1;
                                                axis2 = a3;
                                                axis3 = a2;
                                            }
                                            else
                                            {
                                                axis1 = a1;
                                                axis2 = a2;
                                                axis3 = a3;
                                            }
                                            var oP1 = [bboxData.origin[0], bboxData.origin[1], p1[2] - 0.1];
                                            var oP2 = [bboxData.origin[0] + axis1[0], bboxData.origin[1] + axis1[1], p1[2] - 0.1];
                                            var oP3 = [bboxData.origin[0] + axis2[0], bboxData.origin[1] + axis2[1], p1[2] - 0.1];
                                            var oP4 = [bboxData.origin[0] + axis1[0] + axis2[0], bboxData.origin[1] + axis1[1] + axis2[1], p1[2] - 0.1];
                                            var oP5 = [bboxData.origin[0] + axis3[0], bboxData.origin[1] + axis3[1], p1[2] + 0.1];
                                            var oP6 = [bboxData.origin[0] + axis1[0] + axis3[0], bboxData.origin[1] + axis1[1] + axis3[1], p1[2] + 0.1];
                                            var oP7 = [bboxData.origin[0] + axis3[0] + axis2[0], bboxData.origin[1] + axis3[1] + axis2[1], p1[2] + 0.1];
                                            var oP8 = [bboxData.origin[0] + axis1[0] + axis2[0] + axis3[0], bboxData.origin[1] + axis1[1] + axis2[1] + axis3[1], p1[2] + 0.1];
                                            openingLiftDone = true;
                                            var e = createGeometryCeiling18(oP1,oP2,oP3,oP4,oP5,oP6,oP7,oP8,'18');
                                            desiteAPI.setLinkedObjects(process,e);
                                        }
                                        break;
                                    }
                                }
                            }
                            if(pC1_result == 3 || pC2_result == 3)
                            {
                                break;
                            }
                        }
                    }
                    if(dist < 0 && (pC1_result == 0 || pC2_result == 0) && pC1_result < 2 && pC2_result < 2)
                    {
                        dist = calculateCurrentMaxDistance(pC1_result,pC2_result,pC1,pC2,n_div,__currentSlabData__[a][0],inner);
                    }
                    if(i > 0 && (localArea < __dep__[10].value) && dist > __dep__[8].value)
                    {
                        var addProp = '1,2,3,17,19,20';
                        if(!innerDone)
                        {
                            var e = createGeometryCeiling17(polyBB[0],polyBB[1],polyBB[2],polyBB[3],polyBB[4],polyBB[5],polyBB[6],polyBB[7],addProp);
                            desiteAPI.setLinkedObjects(process,e);
                            innerDone = true;
                        }
                        break;
                    }
                    if(dist > __dep__[8].value && (pC1_result == 0 || pC2_result == 0) && pC1_result < 2 && pC2_result < 2)
                    {
                        var p = frameworkCheck(pC1,pC2,n_div,__dep__[9].value);
                        if(p[0] > -1)
                        {
                            addProp += '6,7,8';
                            var res = checkForExistingFrameWork(pC1,pC2,n_div,__dep__[9].value + p[1]);
                            if(res > -1)
                            {
                                dist = res;
                            }
                            var e = [];
                            if(document.getElementById('cb2').checked)
                            {
                                e = createGeometryFramework1(pC1,pC2,dist,n_div,p[1], false);
                            }
                            else
                            {
                                e = createGeometryFramework1(pC1,pC2,dist,n_div,0,false);
                            }
                            desiteAPI.setLinkedObjects(process,e);
                            var fD = parseFloat(document.getElementById('FrameworkDistance').value);
                            var pL1 = [];
                            var pL2 = [];
                            if(document.getElementById('cb2').checked)
                            {
                                pL1 = [pC1[0] + n_div[0] * (fD + p[1]),pC1[1] + n_div[1] * (fD + p[1]),pC1[2] + n_div[2] * (fD + p[1])];
                                pL2 = [pC2[0] + n_div[0] * (fD + p[1]),pC2[1] + n_div[1] * (fD + p[1]),pC2[2] + n_div[2] * (fD + p[1])];
                            }
                            else
                            {
                                pL1 = [pC1[0] + n_div[0] * (fD),pC1[1] + n_div[1] * (fD),pC1[2] + n_div[2] * (fD)];
                                pL2 = [pC2[0] + n_div[0] * (fD),pC2[1] + n_div[1] * (fD),pC2[2] + n_div[2] * (fD)];
                            }
                            e = [];
                            if(fD > __dep__[21].value)
                            {
                                e = checkCurrentFrameworkConsole(pL1,pL2,dist,n_div,p1,p2,true,addProp,false,inner);
                            }
                            else
                            {
                                e = checkCurrentFrameworkConsole(pL1,pL2,dist,n_div,p1,p2,false,addProp,false,inner);
                            }
                            for(var f = 0; f < e.length; f++)
                            {
                                desiteAPI.setLinkedObjects(process,e[f]);
                            }
                        }
                        else
                        {
                            addProp += '1,2,3';
                            var e = createGeometryCeiling1(pC1,pC2,addProp);
                            desiteAPI.setLinkedObjects(process,e);
                        }
                    }
                }
            }
        }
        if(!cb1)
        {
            var bottomTriangle = getBottomFace(a);
            for(var w = 0; w < bottomTriangle.length; w++)
            {
                var t1 = createGeometryCeiling19(__currentSlabData__[a][3][bottomTriangle[w][0]],__currentSlabData__[a][3][bottomTriangle[w][1]],__currentSlabData__[a][3][bottomTriangle[w][2]],'19,20');
                desiteAPI.setLinkedObjects(process,t1);
            }
            desiteAPI.setLinkedObjects(process,t1);
        }
    }
}

function checkForExistingFrameWork(pC1,pC2,n,d)
{
    var t1 = false;
    var mind = -1;
    var h = 0;
    if(pC1[2] > pC2[2])
    {
        h = pC2[2];
    }
    else
    {
        h = pC1[2];
    }
    var pT1 = [(pC1[0]+pC2[0]) / 2, (pC1[1]+pC2[1]) / 2, h];
    for(var i = 0; i < FWList.length; i++)
    {
        t1 = false;
        var dir = [FWList[i][2]-FWList[i][0],FWList[i][3]-FWList[i][1],0.0];
        if(rayLineDistIntersection2D(pT1,n,[FWList[i][0],FWList[i][1]],dir,d))
        {
            t1 =true;
        }
        if(t1)
        {
            if(mind <0)
            {
                mind = pT1[2] - FWList[i][4];
            } 
            else if(mind>0 && mind > (pT1[2] - FWList[i][4]) && (pT1[2] - FWList[i][4]) >10e-2)
            {
                mind = pT1[2] - FWList[i][4];
            }
        }
    }
    return mind;
}

function checkCurrentFrameworkConsole(p1,p2,d,n,bP1,bP2,bar, addProp,roof,inner)
{
    var qu = parseFloat(document.getElementById('FrameworkDistance').value);
    var checkheigth = parseInt(d / __dep__[17].value);
    var case_FW = 0;
    var ergList = [];
    var i_low = 0;
    var n_neg = [-n[0],-n[1],-n[2]];
    var maxh = 0;
    if(p1[2] > p2[2])
    {
        maxh = p2[2];
    }
    else
    {
        maxh = p1[2];
    }
    var rP1 = [p1[0] + qu * n[0],p1[1] + qu * n[1],p1[2]];
    var rP2 = [p2[0] + qu * n[0],p2[1] + qu * n[1],p2[2]];
    for(var i = 0; i < checkheigth; i++)
    {
        var cP1 = [rP1[0], rP1[1],p1[2] - d + i * __dep__[17].value];
        var cP2 = [rP2[0], rP2[1],p2[2] - d + i * __dep__[17].value];
        var v1 = 0;
        var v2 = 0;
        erg = checkContact(cP1,cP2,cP1,cP2,n_neg,v1,v2,__legacyGeometryData__,null, 1);
        if(erg[0] > v1)
        {
            v1 = erg[0];
        }
        if(erg[1] > v2)
        {
            v2 = erg[1];
        }
        if(v1 && v2)
        {
            if(!case_FW)
            {
                continue;
            }
            else
            {
                var h_low = maxh - d + i_low * __dep__[17].value;
                var h_high = maxh - d + (i-1) * __dep__[17].value;
                var id = createGeometryFramework3(p1,p2,h_low,h_high,n,addProp);
                ergList.push(id);
                case_FW = 0;
                i_low = i-1;
                continue;
            }
        }
        erg = checkContact(cP1,cP2,cP1,cP2,n_neg,v1,v2,__legacySlabData__,null, 1);
        if(erg[0] > v1)
        {
            v1 = erg[0];
        }
        if(erg[1] > v2)
        {
            v2 = erg[1];
        }
        if(v1 && v2)
        {
            if(!case_FW)
            {
                continue;
            }
            else
            {
                var h_low = maxh - d + i_low * __dep__[17].value;
                var h_high = maxh - d + (i-1) * __dep__[17].value;
                var id = createGeometryFramework3(p1,p2,h_low,h_high,n,addProp);
                ergList.push(id);
                case_FW = 0;
                i_low = i-1;
                continue;
            }
        }
        erg = checkContact(cP1,cP2,cP1,cP2,n_neg,v1,v2,__legacyRoofData__,null, 1);
        if(erg[0] > v1)
        {
            v1 = erg[0];
        }
        if(erg[1] > v2)
        {
            v2 = erg[1];
        }
        if(v1 && v2)
        {
            if(!case_FW)
            {
                continue;
            }
            else
            {
                var h_low = maxh - d + i_low * __dep__[17].value;
                var h_high = maxh - d + (i-1) * __dep__[17].value;
                var id = createGeometryFramework3(p1,p2,h_low,h_high,n,addProp);
                ergList.push(id);
                case_FW = 0;
                i_low = i-1;
                continue;
            }
        }
        erg = checkContact(cP1,cP2,cP1,cP2,n_neg,v1,v2,__globalDTMData__,null, 1);
        if(erg[0] > v1)
        {
            v1 = erg[0];
        }
        if(erg[1] > v2)
        {
            v2 = erg[1];
        }
        if(v1 && v2)
        {
            if(!case_FW)
            {
                continue;
            }
            else
            {
                var h_low = maxh - d + i_low * __dep__[17].value;
                var h_high = maxh - d + (i-1) * __dep__[17].value;
                var id = createGeometryFramework3(p1,p2,h_low,h_high,n,addProp);
                ergList.push(id);
                case_FW = 0;
                i_low = i-1;
                continue;
            }
        }
        if(!v1 || !v2)
        {
            var lP1 = [cP1[0] + n_neg[0],cP1[1] + n_neg[1],cP1[2]];
            var lP2 = [cP2[0] + n_neg[0],cP2[1] + n_neg[1],cP2[2]];
            var n_down = [0,0,0];
            var dist = calculateCurrentMaxDistance(v1,v2,lP1,lP2,n_down,null,false);
            if (dist > __dep__[18].value)
            {
                if(case_FW)
                {
                    continue;
                }
                else
                {
                    var h_low = maxh - d + i_low * __dep__[17].value;
                    var h_high = maxh - d + (i-1) * __dep__[17].value;
                    if(bar)
                    {
                        ergList.push(createGeometryFramework2(p1,p2,h_low,h_high,n,addProp));
                    }
                    case_FW = 1;
                    i_low = i-1;
                    continue;
                }
            }
        } 
    }
    if(case_FW)
    {
        var h_low = maxh - d + i_low * __dep__[17].value;
        var h_high = maxh;
        if(!roof)
        {
            h_high = maxh + 0.8; 
        }
        ergList.push(createGeometryFramework3(p1,p2,h_low,h_high,n,addProp));
    }
    else
    {
        var h_low = maxh - d + i_low * __dep__[17].value;
        var h_high = maxh;
        if(!roof)
        {
            h_high = maxh + 0.8; 
        }
        if(bar)
        {
            ergList.push(createGeometryFramework2(p1,p2,h_low,h_high,n,addProp));
        }
    }
    return ergList;
}

function frameworkCheck(pC1,pC2,n,d)
{
    var counter = -1;
    var rec = d+0.1;
    for(var i = 0; i < __frameworkList__.length; i++)
    {
        var dir = [__frameworkList__[i][1][0] - __frameworkList__[i][0][0],__frameworkList__[i][1][1] - __frameworkList__[i][0][1],0.0];
        if(rayLineDistIntersection2D(pC1,n,__frameworkList__[i][0],dir,d))
        {
            if(document.getElementById('cb2').checked)
            {   
                var v = rayLineIntersection_2D_Distance(pC1,n,__frameworkList__[i][0],dir,d);
                if(rec > v && v > -1)
                {
                    if(isOrtho(dir,n,1))
                    {
                        rec = v;
                        counter = i;    
                    }
                }
            }
            else
            {
                if(isOrtho(dir,n,1))
                {
                    counter = 0;    
                }
            }
        }
        else if(rayLineDistIntersection2D(pC2,n,__frameworkList__[i][0],dir,d))
        {
            if(document.getElementById('cb2').checked)
            {   
                var v = rayLineIntersection_2D_Distance(pC2,n,__frameworkList__[i][0],dir,d);
                if(rec > v && v > -1)
                {
                    if(isOrtho(dir,n,1))
                    {
                        rec = v;
                        counter = i;    
                    }
                }
            }
            else
            {
                if(isOrtho(dir,n,1))
                {
                    counter = 0;    
                }
            }
        }
    }
    return [counter,rec];
}

function calculateCurrentMaxDistance(pC1_result,pC2_result,pC1,pC2,n,id,inner)
{
    var d = -1;
    var res = -1;
    if(pC1_result == 0)
    {
        var vario = 0;
        if(inner)
        {
            vario = __dep__[5].value;
        }
        else
        {
            vario = __dep__[7].value;
        }
        var pC4 = [pC1[0] + vario * n[0], pC1[1] + vario * n[1], pC1[2] + vario * n[2]];
        var n_4 = [0,0,-1];
        var erg = 0;
        erg = maxDistanceData(pC4,n_4,__legacyGeometryData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__legacySlabData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__legacyRoofData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        if(__globalDTMData__.length == 0)
        {
            erg = pC4[2];
        }
        else
        {
            erg = maxDistanceData(pC4,n_4,__globalDTMData__,id);
        }
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__currentSlabData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__currentRoofData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
    } 
    res = d;
    d = -1;
    if(pC2_result == 0)
    {
        var vario = 0;
        if(inner)
        {
            vario = __dep__[5].value;
        }
        else
        {
            vario = __dep__[7].value;
        }
        var pC4 = [pC2[0] + vario * n[0], pC2[1] + vario * n[1], pC2[2] + vario * n[2]];
        var n_4 = [0,0,-1];
        var erg = 0;
        erg = maxDistanceData(pC4,n_4,__legacyGeometryData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__legacySlabData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__legacyRoofData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        if(__globalDTMData__.length == 0)
        {
            erg = pC4[2];
        }
        else
        {
            erg = maxDistanceData(pC4,n_4,__globalDTMData__,id);
        }
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__currentSlabData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__currentRoofData__,id);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
    }
    if(d>res)
    {
        res = d;
    }
    return res;
}

function getBottomFace(x)
{
    var bottomFace = 0;
    for(var i = 0; i < __currentSlabData__[x][1].length; i++)
    {
        if (Math.abs(normalVectorZ(__currentSlabData__[x][1][i][0], __currentSlabData__[x][2], __currentSlabData__[x][3]) + 1) < 10e-9)
        {
            bottomFace = i;
        }
    }
    var bottomTriangle = [];
    for(var i = 0; i< __currentSlabData__[x][1][bottomFace].length; i++)
    {
        bottomTriangle.push(__currentSlabData__[x][2][__currentSlabData__[x][1][bottomFace][i]]);
    }
    return bottomTriangle;
}

function getPolygonsCurrent(x)
{
    var topFace = 0;
    for(var i = 0; i < __currentSlabData__[x][1].length; i++)
    {
        if (Math.abs(normalVectorZ(__currentSlabData__[x][1][i][0], __currentSlabData__[x][2], __currentSlabData__[x][3]) -1) < 10e-9)
        {
            topFace = i;
        }
    }
    var topTriangle = [];
    for(var i = 0; i< __currentSlabData__[x][1][topFace].length; i++)
    {
        topTriangle.push(__currentSlabData__[x][2][__currentSlabData__[x][1][topFace][i]]);
    }
    var edgeList = [];
    for(var i = 0; i < topTriangle.length; i++)
    {
        edgeList.push([topTriangle[i][0],topTriangle[i][1]]);
        edgeList.push([topTriangle[i][1],topTriangle[i][2]]);
        edgeList.push([topTriangle[i][2],topTriangle[i][0]]);
    }
    var l = edgeList.length;
    for(var i = 0; i < l - 1; i++)
    {
        for( var j = i + 1; j < l; j++)
        {
            if((edgeList[i][0] == edgeList[j][1] && edgeList[i][1] == edgeList[j][0]) || (edgeList[i][0] == edgeList[j][0] && edgeList[i][1] == edgeList[j][1]))
            {
                edgeList.splice(j,1);
                edgeList.splice(i,1);
                l = l - 2;
                j = i;
            }
        }
    }
    var polyList = [];
    for(var i = 0; i < edgeList.length; i++)
    {
        polyList.push(0);
    }
    var counter = 1;
    var c = 0;
    var polygonPointList = [];
    for(var i = 0; i < polyList.length; i++)
    {
        if(!polyList[i])
        {
            var pList = [];
            polyList[i] = counter;
            var fP = true;
            var close = false;
            c = i;
            while(!close)
            {
                for(var j = 0; j < edgeList.length; j++)
                {
                    if(j != c && !polyList[j])
                    {
                        if(edgeList[c][0] == edgeList[j][0])
                        {
                            if(fP)
                            {
                                pList.push(edgeList[c][1]);
                                fP = false;
                            }
                            pList.push(edgeList[c][0]);
                            polyList[j] = counter;
                            c = j;
                            break;
                        }
                        else if(edgeList[c][0] == edgeList[j][1])
                        {
                            if(fP)
                            {
                                pList.push(edgeList[c][1]);
                                fP = false;
                            }
                            pList.push(edgeList[c][0]);
                            polyList[j] = counter;
                            c = j;
                            break;
                        }
                        else if (edgeList[c][1] == edgeList[j][0])
						{
							if (fP)
							{
								pList.push(edgeList[c][0]);
								fP = false;
							}
							pList.push(edgeList[c][1]);
							polyList[j] = counter;
							c = j;
							break;
						}
						else if (edgeList[c][1] == edgeList[j][1])
						{
							if (fP)
							{
								pList.push(edgeList[c][0]);
								fP = false;
							}
							pList.push(edgeList[c][1]);
							polyList[j] = counter;
							c = j;
							break;
						}
                    }
                    if(j == edgeList.length - 1)
                    {
                        close = true;
                    }
                }
            }
            polygonPointList.push(pList);
            counter++;
        }
    }
    var outerPolygon = 0;
    var outerArea = 0;
    var area = [];
    for(var i = 0; i < polygonPointList.length; i++)
    {
        var cArea = 0.0;
        for(var j = 0; j < polygonPointList[i].length; j++)
        {
            cArea += (__currentSlabData__[x][3][polygonPointList[i][j]][0] - __currentSlabData__[x][3][polygonPointList[i][(j + 1) % polygonPointList[i].length]][0]) * (__currentSlabData__[x][3][polygonPointList[i][j]][1] + __currentSlabData__[x][3][polygonPointList[i][(j + 1) % polygonPointList[i].length]][1]);
        }
        area.push(Math.abs(cArea)/2.0);
        if(area[i] > outerArea)
        {
            outerArea = area[i];
            outerPolygon = i;
        }
    }
    erg = [];
    erg.push([]);
    counter = 1;
    for(var i = 0; i < polygonPointList[outerPolygon].length; i++)
    {
        erg[0].push((__currentSlabData__[x][3][polygonPointList[outerPolygon][i]]));
    }
    for(var i = 0; i < polygonPointList.length; i++)
    {
        if(i != outerPolygon)
        {
            erg.push([]);
            for(var j = 0; j < polygonPointList[i].length; j++)
            {
                erg[counter].push((__currentSlabData__[x][3][polygonPointList[i][j]]));
            }
            counter++;
        }
    }
    return erg;
}

function normalVectorZ(triangle,triangleList,points)
{
    var p1 = points[triangleList[triangle][0]];
    var p2 = points[triangleList[triangle][1]];
    var p3 = points[triangleList[triangle][2]];

    var d1 = [p2[0] - p1[0],p2[1] - p1[1],p2[2] - p1[2]];

    var d2 = [p3[0] - p2[0],p3[1] - p2[1],p3[2] - p2[2]];

    var cP = [d1[1] * d2[2] - d1[2] * d2[1], d1[2] * d2[0] - d1[0] * d2[2], d1[0] * d2[1] - d1[1] * d2[0]];
    var nCP = Math.sqrt(cP[0] * cP[0] + cP[1] * cP[1] + cP[2] * cP[2]);
    return cP[2] / nCP;
}