function getCurrentGeometry(id)
{
    for(var i = 0; i < id.length; i++)
    {
        var t = desiteAPI.getContainedElements(id[i],2);
        if(t.length > 0)
        {
            getCurrentGeometry(t);
            if(desiteAPI.getPropertyValue(id[i],'cpCompositeID','xs:ID') == desiteAPI.getPropertyValue(id[i],'cpID','xs:ID'))
            {
                continue;
            }
        }
        var g = 0;
        for(var j = 0; j < __legacySlabData__.length; j++)
        {
            if(__legacySlabData__[j][0] == id[i])
            {
                g = 1;
                continue;
            }
        }
        if(g)
        {
            continue;
        }
        if(__createdGeo__.indexOf(id[i]) >-1)
        {
            continue;
        }
        if(roofID.indexOf(id[i]) > -1)
        {
            addGeoList(id[i],__currentRoofData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[0].propertyName,__geo__[0].propertyType) == __geo__[0].propertyValue)
        {
            addGeoList(id[i],__currentSlabData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[1].propertyName,__geo__[1].propertyType) == __geo__[1].propertyValue)
        {
            addGeoList(id[i],__currentLiftOpeningData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[2].propertyName,__geo__[2].propertyType) == __geo__[2].propertyValue)
        {
            continue;
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[3].propertyName,__geo__[3].propertyType) == __geo__[3].propertyValue)
        {
            continue;
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[4].propertyName,__geo__[4].propertyType) == __geo__[4].propertyValue)
        {
            continue;
        }
        else if(frameworkID.indexOf(id[i]) == -1)
        {
            addGeoList(id[i],__legacyGeometryData__);
        }
    }
}

function getPolygonsBB(poly)
{
    var min_x;
    var max_x;
    var min_y;
    var max_y;
    var min_z;
    var max_z;
    if(poly.length == 4)
    {
        var p1 = [poly[0][0],poly[0][1],poly[0][2] - 0.1];
        var p2 = [poly[1][0],poly[1][1],poly[1][2] - 0.1];
        var p3 = [poly[3][0],poly[3][1],poly[3][2] - 0.1];
        var p4 = [poly[2][0],poly[2][1],poly[2][2] - 0.1];
        var p5 = [poly[0][0],poly[0][1],poly[0][2] + 0.1];
        var p6 = [poly[1][0],poly[1][1],poly[1][2] + 0.1];
        var p7 = [poly[3][0],poly[3][1],poly[3][2] + 0.1];
        var p8 = [poly[2][0],poly[2][1],poly[2][2] + 0.1];
        var erg = [];
        erg.push(p1);
        erg.push(p2);
        erg.push(p3);
        erg.push(p4);
        erg.push(p5);
        erg.push(p6);
        erg.push(p7);
        erg.push(p8);
        return erg;
    }
    for(var i = 0; i < poly.length; i++)
    {
        if(i == 0)
        {
            min_x = poly[i][0];
            max_x = poly[i][0];
            min_y = poly[i][1];
            max_y = poly[i][1];
            min_z = poly[i][2];
            max_z = poly[i][2];
        }
        else
        {
            if(min_x > poly[i][0])
            {
                min_x = poly[i][0];
            }
            else if(max_x < poly[i][0])
            {
                max_x = poly[i][0]
            }
            if(min_y > poly[i][1])
            {
                min_y = poly[i][1];
            }
            else if(max_y < poly[i][1])
            {
                max_y = poly[i][1]
            }
            if(min_z > poly[i][2])
            {
                min_z = poly[i][2];
            }
            else if(max_z < poly[i][2])
            {
                max_z = poly[i][2]
            }
        }
    }
    if(Math.abs(max_z - min_z) > 10e-6)
    {
        var p1 = [min_x,min_y,min_z];
        var p2 = [min_x,max_y,min_z];
        var p3 = [max_x,min_y,min_z];
        var p4 = [max_x,max_y,min_z];
        var p5 = [min_x,min_y,max_z];
        var p6 = [min_x,max_y,max_z];
        var p7 = [max_x,min_y,max_z];
        var p8 = [max_x,max_y,max_z];
        var erg = [];
        erg.push(p1);
        erg.push(p2);
        erg.push(p3);
        erg.push(p4);
        erg.push(p5);
        erg.push(p6);
        erg.push(p7);
        erg.push(p8);
    }
    else
    {
        var p1 = [min_x,min_y,min_z - 0.1];
        var p2 = [min_x,max_y,min_z - 0.1];
        var p3 = [max_x,min_y,min_z - 0.1];
        var p4 = [max_x,max_y,min_z - 0.1];
        var p5 = [min_x,min_y,max_z + 0.1];
        var p6 = [min_x,max_y,max_z + 0.1];
        var p7 = [max_x,min_y,max_z + 0.1];
        var p8 = [max_x,max_y,max_z + 0.1];
        var erg = [];
        erg.push(p1);
        erg.push(p2);
        erg.push(p3);
        erg.push(p4);
        erg.push(p5);
        erg.push(p6);
        erg.push(p7);
        erg.push(p8);
    }
    return erg;
}

function updateCurrentGeometry()
{
    for(var i = 0; i < __currentSlabData__.length; i++)
    {
        addGeoList(__currentSlabData__[i][0],__legacySlabData__);
    }
    for(var i = 0; i < __currentRoofData__.length; i++)
    {
        addGeoList(__currentRoofData__[i][0],__legacyRoofData__);
    }
    for(var i = 0; i < __currentLiftOpeningData__.length; i++)
    {
        addGeoList(__currentLiftOpeningData__[i][0], __legacyLiftOpeningData__);
    }
    __currentSlabData__ = [];
    __currentRoofData__ = [];
    __currentLiftOpeningData__ = [];
}

function getGeometryDataAll()
{
    desiteAPI.showAll(true);

    var id = desiteAPI.getVisibleElements();
    var l = [];
    for(var i = 0; i < id.length; i++)
    {
        l.push(desiteAPI.getAsJSON(id[i]));
    }
    var d = [];
    for(var i = 0; i < id.length; i++)
    {
        if(roofID.indexOf(id[i]) > -1)
        {
            addGeoList(id[i],__globalRoofData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[0].propertyName,__geo__[0].propertyType) == __geo__[0].propertyValue)
        {
            addGeoList(id[i],__globalSlabData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[1].propertyName,__geo__[1].propertyType) == __geo__[1].propertyValue)
        {
            addGeoList(id[i],__globalLiftOpeningData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[2].propertyName,__geo__[2].propertyType) == __geo__[2].propertyValue)
        {
            addGeoList(id[i],__globalLiftData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[3].propertyName,__geo__[3].propertyType) == __geo__[3].propertyValue)
        {
            addGeoList(id[i],__globalDTMData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[4].propertyName,__geo__[4].propertyType) == __geo__[4].propertyValue)
        {
            addGeoList(id[i],__globalOpeningData__);
        }
        else if(frameworkID.indexOf(id[i]) == -1)
        {
            addGeoList(id[i],__globalGeometryData__);
        }
    }
}

function getGeometryData(id)
{
    for(var i = 0; i < id.length; i++)
    {
        var t = desiteAPI.getContainedElements(id[i],2);
        if(t.length > 0)
        {
            getGeometryData(t);
            if(desiteAPI.getPropertyValue(id[i],'cpCompositeID','xs:ID') == desiteAPI.getPropertyValue(id[i],'cpID','xs:ID'))
            {
                continue;
            }
        }
        if(roofID.indexOf(id[i]) > -1)
        {
            addGeoList(id[i],__globalRoofData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[0].propertyName,__geo__[0].propertyType) == __geo__[0].propertyValue)
        {
            addGeoList(id[i],__globalSlabData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[1].propertyName,__geo__[1].propertyType) == __geo__[1].propertyValue)
        {
            addGeoList(id[i],__globalLiftOpeningData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[2].propertyName,__geo__[2].propertyType) == __geo__[2].propertyValue)
        {
            addGeoList(id[i],__globalLiftData__);
        }
        else if(desiteAPI.getPropertyValue(id[i],__geo__[3].propertyName,__geo__[3].propertyType) == __geo__[3].propertyValue)
        {
            addGeoList(id[i],__globalDTMData__);
        }
        else if(frameworkID.indexOf(id[i]) == -1)
        {
            addGeoList(id[i],__globalGeometryData__);
        }
    }
}


function addGeoList(id,Data)
{
    for(var i = 0; i < Data.length; i++)
    {
        if(id == Data[i][0])
        {
            return 0;
        }
    }
    var list = desiteAPI.getAsJSON(id);
    var min_x = 0;
    var min_y = 0;
    var min_z = 0;
    var max_x = 0;
    var max_y = 0;
    var max_z = 0;
    if (list.vertexList == undefined)
    {
        return;
    }
    Data.push([]);
    Data[Data.length - 1].push(id);
    Data[Data.length - 1].push([]);
    if(list.faceList != undefined)
    {
        for(var i = 0; i < list.faceList.length; i++)
        {
            Data[Data.length - 1][1].push([]);
            for(var j = 0; j < list.faceList[i].length; j++)
            {
                Data[Data.length - 1][1][i].push(list.faceList[i][j]);
            }
        }
    }
    Data[Data.length - 1].push([]);
    if(list.triangleList != undefined)
    {
        for(var j = 0; j < list.triangleList.length; j = j + 3)
        {
            Data[Data.length - 1][2].push([list.triangleList[j],list.triangleList[j+1],list.triangleList[j+2]]);
        }       
    }
    Data[Data.length - 1].push([]);
    if(list.vertexList != undefined)
    {
        for(var j = 0; j < list.vertexList.length; j = j + 3)
        {
            if (j == 0)
            {
                min_x = list.vertexList[j];
                max_x = list.vertexList[j];
                min_y = list.vertexList[j+1];
                max_y = list.vertexList[j+1];
                min_z = list.vertexList[j+2];
                max_z = list.vertexList[j+2];
            }
            Data[Data.length - 1][3].push([list.vertexList[j],list.vertexList[j+1],list.vertexList[j+2]]);
            if(list.vertexList[j] > max_x)
            {
                max_x = list.vertexList[j];
            }
            else if(list.vertexList[j] < min_x)
            {
                min_x = list.vertexList[j];
            }

            if(list.vertexList[j+1] > max_y)
            {
                max_y = list.vertexList[j+1];
            }
            else if(list.vertexList[j+1] < min_y)
            {
                min_y = list.vertexList[j+1];
            }
            
            if(list.vertexList[j+2] > max_z)
            {
                max_z = list.vertexList[j+2];
            }
            else if(list.vertexList[j+2] < min_z)
            {
                min_z = list.vertexList[j+2];
            }
        }
    }
    Data[Data.length - 1].push([min_x,min_y,min_z,max_x,max_y,max_z]);
}

function createModel(gMN)
{
    return desiteAPI.createModel(gMN);  
}

function createGeometryDTM(e1,e2,addProp)
{
    var nor1 = [1.0,1.0];
    var id = __internal__[10].txt + globalDTMCounter;
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor1">';
    str += '<p nr="0" x="'+(e1[0] + 0.05 * nor1[0])+'" y="'+(e1[1] + 0.05 * nor1[1])+'" z="'+e1[2]+'" />';
    str += '<p nr="1" x="'+(e2[0] + 0.05 * nor1[0])+'" y="'+(e2[1] + 0.05 * nor1[1])+'" z="'+e2[2]+'" />';
    str += '<p nr="2" x="'+(e1[0] - 0.05 * nor1[0])+'" y="'+(e1[1] - 0.05 * nor1[1])+'" z="'+e1[2]+'" />';
    str += '<p nr="3" x="'+(e2[0] - 0.05 * nor1[0])+'" y="'+(e2[1] - 0.05 * nor1[1])+'" z="'+e2[2]+'" />';
    str += '<p nr="4" x="'+(e1[0] + 0.05 * nor1[0])+'" y="'+(e1[1] + 0.05 * nor1[1])+'" z="'+(e1[2] + 1)+'" />';
    str += '<p nr="5" x="'+(e2[0] + 0.05 * nor1[0])+'" y="'+(e2[1] + 0.05 * nor1[1])+'" z="'+(e2[2] + 1)+'" />';
    str += '<p nr="6" x="'+(e1[0] - 0.05 * nor1[0])+'" y="'+(e1[1] - 0.05 * nor1[1])+'" z="'+(e1[2] + 1)+'" />';
    str += '<p nr="7" x="'+(e2[0] - 0.05 * nor1[0])+'" y="'+(e2[1] - 0.05 * nor1[1])+'" z="'+(e2[2] + 1)+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalDTMFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','1,2,3,5');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcRailing');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','1_Seitenschutz_konventionell');
    //desiteAPI.setMaterialToObjects('ModelColor1',id);
    globalDTMCounter = globalDTMCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'1,2,3,5');
    return id;
}

function createGeometryCeiling17(p1,p2,p3,p4,p5,p6,p7,p8,addProp)
{
    var id = __internal__[11].txt + globalCeilingCounter;
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor3">';
    str += '<p nr="0" x="'+p1[0]+'" y="'+p1[1]+'" z="'+p1[2]+'" />';
    str += '<p nr="1" x="'+p2[0]+'" y="'+p2[1]+'" z="'+p2[2]+'" />';
    str += '<p nr="2" x="'+p3[0]+'" y="'+p3[1]+'" z="'+p3[2]+'" />';
    str += '<p nr="3" x="'+p4[0]+'" y="'+p4[1]+'" z="'+p4[2]+'" />';
    str += '<p nr="4" x="'+p5[0]+'" y="'+p5[1]+'" z="'+p5[2]+'" />';
    str += '<p nr="5" x="'+p6[0]+'" y="'+p6[1]+'" z="'+p6[2]+'" />';
    str += '<p nr="6" x="'+p7[0]+'" y="'+p7[1]+'" z="'+p7[2]+'" />';
    str += '<p nr="7" x="'+p8[0]+'" y="'+p8[1]+'" z="'+p8[2]+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalCeilingFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','1,2,3,17,19,20');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcSlab');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','17_Abdeckung');
    //desiteAPI.setMaterialToObjects('ModelColor3',id);
    globalCeilingCounter = globalCeilingCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'1,2,3,17,19,20');
    return id;
}

function createGeometryCeiling18(p1,p2,p3,p4,p5,p6,p7,p8)
{
    var id = __internal__[11].txt + globalCeilingCounter;
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor3">';
    str += '<p nr="0" x="'+p1[0]+'" y="'+p1[1]+'" z="'+p1[2]+'" />';
    str += '<p nr="1" x="'+p2[0]+'" y="'+p2[1]+'" z="'+p2[2]+'" />';
    str += '<p nr="2" x="'+p3[0]+'" y="'+p3[1]+'" z="'+p3[2]+'" />';
    str += '<p nr="3" x="'+p4[0]+'" y="'+p4[1]+'" z="'+p4[2]+'" />';
    str += '<p nr="4" x="'+p5[0]+'" y="'+p5[1]+'" z="'+p5[2]+'" />';
    str += '<p nr="5" x="'+p6[0]+'" y="'+p6[1]+'" z="'+p6[2]+'" />';
    str += '<p nr="6" x="'+p7[0]+'" y="'+p7[1]+'" z="'+p7[2]+'" />';
    str += '<p nr="7" x="'+p8[0]+'" y="'+p8[1]+'" z="'+p8[2]+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalCeilingFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','18');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcSlab');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','18_Liftschachtgerüst');
    //desiteAPI.setMaterialToObjects('ModelColor3',id);
    globalCeilingCounter = globalCeilingCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'18');
    return id;
}

function createGeometryCeiling19(p1, p2, p3,addProp)
{
    var id = __internal__[11].txt + globalCeilingCounter;
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor10">';
    str += '<p nr="0" x="'+p1[0]+'" y="'+p1[1]+'" z="'+(p1[2]-0.05)+'" />';
    str += '<p nr="1" x="'+p2[0]+'" y="'+p2[1]+'" z="'+(p2[2]-0.05)+'" />';
    str += '<p nr="2" x="'+p3[0]+'" y="'+p3[1]+'" z="'+(p3[2]-0.05)+'" />';
    str += '<p nr="3" x="'+p1[0]+'" y="'+p1[1]+'" z="'+p1[2]+'" />';
    str += '<p nr="4" x="'+p2[0]+'" y="'+p2[1]+'" z="'+p2[2]+'" />';
    str += '<p nr="5" x="'+p3[0]+'" y="'+p3[1]+'" z="'+p3[2]+'" />';
    str += '<t nr="0" p1="0" p2="1" p3="2" />';
    str += '<t nr="1" p1="0" p2="1" p3="3" />';
    str += '<t nr="2" p1="3" p2="1" p3="4" />';
    str += '<t nr="3" p1="0" p2="2" p3="3" />';
    str += '<t nr="4" p1="2" p2="3" p3="5" />';
    str += '<t nr="5" p1="1" p2="2" p3="4" />';
    str += '<t nr="6" p1="2" p2="4" p3="5" />';
    str += '<t nr="7" p1="3" p2="4" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalCeilingFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','19,20');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcSlab');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','19_Auffangnetz');
    //desiteAPI.setMaterialToObjects('ModelColor10',id);
    globalCeilingCounter = globalCeilingCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'19,20');
    return id;
}

function createGeometryRoof20(p1, p2, p3, lP,addProp)
{
    var id = __internal__[12].txt + globalRoofCounter;
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor10">';
    str += '<p nr="0" x="'+p1[0]+'" y="'+p1[1]+'" z="'+(lP-0.1)+'" />';
    str += '<p nr="1" x="'+p2[0]+'" y="'+p2[1]+'" z="'+(lP-0.1)+'" />';
    str += '<p nr="2" x="'+p3[0]+'" y="'+p3[1]+'" z="'+(lP-0.1)+'" />';
    str += '<p nr="3" x="'+p1[0]+'" y="'+p1[1]+'" z="'+lP+'" />';
    str += '<p nr="4" x="'+p2[0]+'" y="'+p2[1]+'" z="'+lP+'" />';
    str += '<p nr="5" x="'+p3[0]+'" y="'+p3[1]+'" z="'+lP+'" />';
    str += '<t nr="0" p1="0" p2="1" p3="2" />';
    str += '<t nr="1" p1="0" p2="1" p3="3" />';
    str += '<t nr="2" p1="3" p2="1" p3="4" />';
    str += '<t nr="3" p1="0" p2="2" p3="3" />';
    str += '<t nr="4" p1="2" p2="3" p3="5" />';
    str += '<t nr="5" p1="1" p2="2" p3="4" />';
    str += '<t nr="6" p1="2" p2="4" p3="5" />';
    str += '<t nr="7" p1="3" p2="4" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalRoofFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','19,20');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcSlab');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','20_Fanggerüst');
    //desiteAPI.setMaterialToObjects('ModelColor10',id);
    globalRoofCounter = globalRoofCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'19,20');
    return id;
}

function createGeometryCeiling4(p1, p2, z, n)
{
    var id = __internal__[11].txt + globalCeilingCounter;
    var str = '<object3D ID="' + id +'" name="'+id+'" matID="ModelColor1">';
    str += '<p nr="0" x="'+(p1[0] + 0.1 * n[0])+'" y="'+(p1[1] + 0.1 * n[1])+'" z="'+z+'" />';
    str += '<p nr="1" x="'+(p2[0] + 0.1 * n[0])+'" y="'+(p2[1] + 0.1 * n[1])+'" z="'+z+'" />';
    str += '<p nr="2" x="'+(p1[0])+'" y="'+(p1[1])+'" z="'+z+'" />';
    str += '<p nr="3" x="'+(p2[0])+'" y="'+(p2[1])+'" z="'+z+'" />';
    str += '<p nr="4" x="'+(p1[0] + 0.1 * n[0])+'" y="'+(p1[1] + 0.1 * n[1])+'" z="'+(p1[2])+'" />';
    str += '<p nr="5" x="'+(p2[0] + 0.1 * n[0])+'" y="'+(p2[1] + 0.1 * n[1])+'" z="'+(p2[2])+'" />';
    str += '<p nr="6" x="'+(p1[0])+'" y="'+(p1[1])+'" z="'+(p1[2])+'" />';
    str += '<p nr="7" x="'+(p2[0])+'" y="'+(p2[1])+'" z="'+(p2[2])+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalCeilingFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','4');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcSlab');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','4_Seitenschutz_Wandöffnung');
    //desiteAPI.setMaterialToObjects('ModelColor1',id);
    globalCeilingCounter = globalCeilingCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'4');
    return id;
}

function createGeometryCeiling1(p1, p2,addProp)
{
    var id = __internal__[11].txt + globalCeilingCounter;
    var dir = [p2[0] - p1[0], p2[1] - p1[1]];
    var dir_n = Math.sqrt(dir[0] * dir[0] + dir[1] * dir[1]);
    var nor1 = [-dir[1]/ dir_n,dir[0]/dir_n];
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor1">';
    str += '<p nr="0" x="'+(p1[0] + 0.05 * nor1[0])+'" y="'+(p1[1] + 0.05 * nor1[1])+'" z="'+p1[2]+'" />';
    str += '<p nr="1" x="'+(p2[0] + 0.05 * nor1[0])+'" y="'+(p2[1] + 0.05 * nor1[1])+'" z="'+p2[2]+'" />';
    str += '<p nr="2" x="'+(p1[0] - 0.05 * nor1[0])+'" y="'+(p1[1] - 0.05 * nor1[1])+'" z="'+p1[2]+'" />';
    str += '<p nr="3" x="'+(p2[0] - 0.05 * nor1[0])+'" y="'+(p2[1] - 0.05 * nor1[1])+'" z="'+p2[2]+'" />';
    str += '<p nr="4" x="'+(p1[0] + 0.05 * nor1[0])+'" y="'+(p1[1] + 0.05 * nor1[1])+'" z="'+(p1[2] + 1)+'" />';
    str += '<p nr="5" x="'+(p2[0] + 0.05 * nor1[0])+'" y="'+(p2[1] + 0.05 * nor1[1])+'" z="'+(p2[2] + 1)+'" />';
    str += '<p nr="6" x="'+(p1[0] - 0.05 * nor1[0])+'" y="'+(p1[1] - 0.05 * nor1[1])+'" z="'+(p1[2] + 1)+'" />';
    str += '<p nr="7" x="'+(p2[0] - 0.05 * nor1[0])+'" y="'+(p2[1] - 0.05 * nor1[1])+'" z="'+(p2[2] + 1)+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalCeilingFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','1,2,3');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcRailing');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','1_Seitenschutz_konventionell');
    //desiteAPI.setMaterialToObjects('ModelColor1',id);
    globalCeilingCounter = globalCeilingCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'1,2,3');
    return id;
}

function createGeometryRoof11(p1, p2, n, addProp, d)
{
    var id = __internal__[12].txt + globalRoofCounter;
    var lP = 0;
    if(p1[2] > p2[2])
    {
        lP = p2[2];
    }
    else
    {
        lP = p1[2];
    }
    var dist = parseFloat(document.getElementById('FrameworkDistance').value);
    var str = '<object3D ID="'+ id+'" name="'+id+'" matID="ModelColor5">';
    str += '<p nr="0" x="'+(p1[0] + (0.6 + d + dist) * n[0])+'" y="'+(p1[1] + (0.6 + d + dist) * n[1])+'" z="'+(lP)+'" />';
    str += '<p nr="1" x="'+(p2[0] + (0.6 + d + dist) * n[0])+'" y="'+(p2[1] + (0.6 + d + dist) * n[1])+'" z="'+(lP)+'" />';
    str += '<p nr="2" x="'+(p1[0] + (0.5 + d + dist) * n[0])+'" y="'+(p1[1] + (0.5 + d + dist) * n[1])+'" z="'+(lP)+'" />';
    str += '<p nr="3" x="'+(p2[0] + (0.5 + d + dist) * n[0])+'" y="'+(p2[1] + (0.5 + d + dist) * n[1])+'" z="'+(lP)+'" />';
    str += '<p nr="4" x="'+(p1[0] + (0.6 + d + dist) * n[0])+'" y="'+(p1[1] + (0.6 + d + dist) * n[1])+'" z="'+(p1[2] + 1)+'" />';
    str += '<p nr="5" x="'+(p2[0] + (0.6 + d + dist) * n[0])+'" y="'+(p2[1] + (0.6 + d + dist) * n[1])+'" z="'+(p2[2] + 1)+'" />';
    str += '<p nr="6" x="'+(p1[0] + (0.5 + d + dist) * n[0])+'" y="'+(p1[1] + (0.5 + d + dist) * n[1])+'" z="'+(p1[2] + 1)+'" />';
    str += '<p nr="7" x="'+(p2[0] + (0.5 + d + dist) * n[0])+'" y="'+(p2[1] + (0.5 + d + dist) * n[1])+'" z="'+(p2[2] + 1)+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalRoofFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','11');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcRailing');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','11_Dachgerüst_Flachdach');
    //desiteAPI.setMaterialToObjects('ModelColor5',id);
    globalRoofCounter = globalRoofCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'11');
    return id;
}

function createGeometryRoof1(p1, p2, n, addProp)
{
    var id = __internal__[12].txt + globalRoofCounter;
    var lP = 0;
    if(p1[2] > p2[2])
    {
        lP = p2[2];
    }
    else
    {
        lP = p1[2];
    }
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor1">';
    str += '<p nr="0" x="'+(p1[0] + 0.05 * n[0])+'" y="'+(p1[1] + 0.05 * n[1])+'" z="'+(lP) +'" />';
    str += '<p nr="1" x="'+(p2[0] + 0.05 * n[0])+'" y="'+(p2[1] + 0.05 * n[1])+'" z="'+(lP) +'" />';
    str += '<p nr="2" x="'+(p1[0] - 0.05 * n[0])+'" y="'+(p1[1] - 0.05 * n[1])+'" z="'+(lP) +'" />';
    str += '<p nr="3" x="'+(p2[0] - 0.05 * n[0])+'" y="'+(p2[1] - 0.05 * n[1])+'" z="'+(lP) +'" />';
    str += '<p nr="4" x="'+(p1[0] + 0.05 * n[0])+'" y="'+(p1[1] + 0.05 * n[1])+'" z="'+(p1[2] + 1)+'" />';
    str += '<p nr="5" x="'+(p2[0] + 0.05 * n[0])+'" y="'+(p2[1] + 0.05 * n[1])+'" z="'+(p2[2] + 1)+'" />';
    str += '<p nr="6" x="'+(p1[0] - 0.05 * n[0])+'" y="'+(p1[1] - 0.05 * n[1])+'" z="'+(p1[2] + 1)+'" />';
    str += '<p nr="7" x="'+(p2[0] - 0.05 * n[0])+'" y="'+(p2[1] - 0.05 * n[1])+'" z="'+(p2[2] + 1)+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalRoofFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','1,2,3');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcRailing');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','1_Seitenschutz_konventionell');
    //desiteAPI.setMaterialToObjects('ModelColor1',id);
    globalRoofCounter = globalRoofCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'1,2,3');
    return id;
}

function createGeometryRoof13(p1, p2, n, addProp, d)
{
    var id = __internal__[12].txt + globalRoofCounter;
    var lP = 0;
    if(p1[2] > p2[2])
    {
        lP = p2[2];
    }
    else
    {
        lP = p1[2];
    }
    var dist = parseFloat(document.getElementById('FrameworkDistance').value);
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor5">';
    str += '<p nr="0" x="'+(p1[0] + (0.6 + dist + d) * n[0])+'" y="'+(p1[1] + (0.6 + dist + d) * n[1])+'" z="'+lP+'" />';
    str += '<p nr="1" x="'+(p2[0] + (0.6 + dist + d) * n[0])+'" y="'+(p2[1] + (0.6 + dist + d) * n[1])+'" z="'+lP+'" />';
    str += '<p nr="2" x="'+(p1[0] + (dist + d) * n[0])+'" y="'+(p1[1] + (dist + d) * n[1])+'" z="'+lP+'" />';
    str += '<p nr="3" x="'+(p2[0] + (dist + d) * n[0])+'" y="'+(p2[1] + (dist + d) * n[1])+'" z="'+lP+'" />';
    str += '<p nr="4" x="'+(p1[0] + (0.6 + dist + d) * n[0])+'" y="'+(p1[1] + (0.6 + dist + d) * n[1])+'" z="'+(p1[2] +0.8)+'" />';
    str += '<p nr="5" x="'+(p2[0] + (0.6 + dist + d) * n[0])+'" y="'+(p2[1] + (0.6 + dist + d) * n[1])+'" z="'+(p2[2] +0.8)+'" />';
    str += '<p nr="6" x="'+(p1[0] + (dist + d) * n[0])+'" y="'+(p1[1] + (dist + d) * n[1])+'" z="'+(p1[2] +0.8)+'" />';
    str += '<p nr="7" x="'+(p2[0] + (dist + d) * n[0])+'" y="'+(p2[1] + (dist + d) * n[1])+'" z="'+(p2[2] +0.8)+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalRoofFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','13');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcWall');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','13_Dachgerüst_Dachdeckerschutzwand');
    //desiteAPI.setMaterialToObjects('ModelColor5',id);
    globalRoofCounter = globalRoofCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'13');
    return id;
}

function createGeometryRoof15(p1, p2, n, addProp, d)
{
    var id = __internal__[12].txt + globalRoofCounter;
    var lP = 0;
    if(p1[2] > p2[2])
    {
        lP = p2[2];
    }
    else
    {
        lP = p1[2];
    }
    var dist = parseFloat(document.getElementById('FrameworkDistance').value);
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor5">';
    str += '<p nr="0" x="'+(p1[0] + (0.6 + dist + d) * n[0])+'" y="'+(p1[1] + (0.6 + dist + d) * n[1])+'" z="'+lP+'" />';
    str += '<p nr="1" x="'+(p2[0] + (0.6 + dist + d) * n[0])+'" y="'+(p2[1] + (0.6 + dist + d) * n[1])+'" z="'+lP+'" />';
    str += '<p nr="2" x="'+(p1[0] + (dist + d) * n[0])+'" y="'+(p1[1] + (dist + d) * n[1])+'" z="'+lP+'" />';
    str += '<p nr="3" x="'+(p2[0] + (dist + d) * n[0])+'" y="'+(p2[1] + (dist + d) * n[1])+'" z="'+lP+'" />';
    str += '<p nr="4" x="'+(p1[0] + (0.6 + dist + d) * n[0])+'" y="'+(p1[1] + (0.6 + dist + d) * n[1])+'" z="'+(p1[2] +0.8)+'" />';
    str += '<p nr="5" x="'+(p2[0] + (0.6 + dist + d) * n[0])+'" y="'+(p2[1] + (0.6 + dist + d) * n[1])+'" z="'+(p2[2] +0.8)+'" />';
    str += '<p nr="6" x="'+(p1[0] + (dist + d) * n[0])+'" y="'+(p1[1] + (dist + d) * n[1])+'" z="'+(p1[2] +0.8)+'" />';
    str += '<p nr="7" x="'+(p2[0] + (dist + d) * n[0])+'" y="'+(p2[1] + (dist + d) * n[1])+'" z="'+(p2[2] +0.8)+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalRoofFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','14,15');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcWall');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','15_Dachgerüst_Giebelseite_mit_Arbeitsraum');
    //desiteAPI.setMaterialToObjects('ModelColor5',id);
    globalRoofCounter = globalRoofCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'14,15');
    return id;
}

function createGeometryRoof12(p1, p2, n, addProp, d)
{
    var id = __internal__[12].txt + globalRoofCounter;
    var lP = 0;
    if(p1[2] > p2[2])
    {
        lP = p2[2];
    }
    else
    {
        lP = p1[2];
    }
    var dist = parseFloat(document.getElementById('FrameworkDistance').value);
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor5">';
    str += '<p nr="0" x="'+(p1[0] + (0.6 + dist + d) * n[0])+'" y="'+(p1[1] + (0.6 + dist + d) * n[1])+'" z="'+(lP)+'" />';
    str += '<p nr="1" x="'+(p2[0] + (0.6 + dist + d) * n[0])+'" y="'+(p2[1] + (0.6 + dist + d) * n[1])+'" z="'+(lP)+'" />';
    str += '<p nr="2" x="'+(p1[0] + (dist + d) * n[0])+'" y="'+(p1[1] + (dist + d) * n[1])+'" z="'+(lP)+'" />';
    str += '<p nr="3" x="'+(p2[0] + (dist + d) * n[0])+'" y="'+(p2[1] + (dist + d) * n[1])+'" z="'+(lP)+'" />';
    str += '<p nr="4" x="'+(p1[0] + (0.6 + dist + d) * n[0])+'" y="'+(p1[1] + (0.6 + dist + d) * n[1])+'" z="'+(p1[2] +0.8)+'" />';
    str += '<p nr="5" x="'+(p2[0] + (0.6 + dist + d) * n[0])+'" y="'+(p2[1] + (0.6 + dist + d) * n[1])+'" z="'+(p2[2] +0.8)+'" />';
    str += '<p nr="6" x="'+(p1[0] + (dist + d) * n[0])+'" y="'+(p1[1] + (dist + d) * n[1])+'" z="'+(p1[2] +0.8)+'" />';
    str += '<p nr="7" x="'+(p2[0] + (dist + d) * n[0])+'" y="'+(p2[1] + (dist + d) * n[1])+'" z="'+(p2[2] +0.8)+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalRoofFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','12');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcWall');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','12_Dachgerüst_Spenglergang');
    //desiteAPI.setMaterialToObjects('ModelColor5',id);
    globalRoofCounter = globalRoofCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'12');
    return id;
}

function createGeometryRoof17(p1,p2,p3,p4,p5,p6,p7,p8,addProp)
{
    var id = __internal__[12].txt + globalRoofCounter;
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor3">';
    str += '<p nr="0" x="'+p1[0]+'" y="'+p1[1]+'" z="'+p1[2]+'" />';
    str += '<p nr="1" x="'+p2[0]+'" y="'+p2[1]+'" z="'+p2[2]+'" />';
    str += '<p nr="2" x="'+p3[0]+'" y="'+p3[1]+'" z="'+p3[2]+'" />';
    str += '<p nr="3" x="'+p4[0]+'" y="'+p4[1]+'" z="'+p4[2]+'" />';
    str += '<p nr="4" x="'+p5[0]+'" y="'+p5[1]+'" z="'+p5[2]+'" />';
    str += '<p nr="5" x="'+p6[0]+'" y="'+p6[1]+'" z="'+p6[2]+'" />';
    str += '<p nr="6" x="'+p7[0]+'" y="'+p7[1]+'" z="'+p7[2]+'" />';
    str += '<p nr="7" x="'+p8[0]+'" y="'+p8[1]+'" z="'+p8[2]+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalRoofFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string',addProp);
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcSlab');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','17_Abdeckung');
    desiteAPI.setMaterialToObjects('ModelColor3',id);
    globalRoofCounter = globalRoofCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,addProp);
    return id;
}

//GERÜST
function createGeometryFramework1(p1,p2,d,n,c,roof)
{
    var id = __internal__[14].txt + globalCeilingCounter;
    var add = 0.8;
    if(roof)
    {
        add = 0;
    }
    var lP = 0
    if(p1[2] > p2[2])
    {
        lP = p2[2];
    }
    else
    {
        lP = p1[2];
    }
    var dist = parseFloat(document.getElementById('FrameworkDistance').value);
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor5">';
    str += '<p nr="0" x="'+(p1[0] + (0.6 + dist + c) * n[0])+'" y="'+(p1[1] + (0.6 + dist + c) * n[1])+'" z="'+(lP-d)+'" />';
    str += '<p nr="1" x="'+(p2[0] + (0.6 + dist + c) * n[0])+'" y="'+(p2[1] + (0.6 + dist + c) * n[1])+'" z="'+(lP-d)+'" />';
    str += '<p nr="2" x="'+(p1[0]+ (dist + c) * n[0])+'" y="'+(p1[1]+ (dist + c) * n[1])+'" z="'+(lP-d)+'" />';
    str += '<p nr="3" x="'+(p2[0]+ (dist + c) * n[0])+'" y="'+(p2[1]+ (dist + c) * n[1])+'" z="'+(lP-d)+'" />';
    str += '<p nr="4" x="'+(p1[0] + (0.6 + dist + c) * n[0])+'" y="'+(p1[1] + (0.6 + dist + c) * n[1])+'" z="'+(lP + add)+'" />';
    str += '<p nr="5" x="'+(p2[0] + (0.6 + dist + c) * n[0])+'" y="'+(p2[1] + (0.6 + dist + c) * n[1])+'" z="'+(lP + add)+'" />';
    str += '<p nr="6" x="'+(p1[0]+ (dist + c) * n[0])+'" y="'+(p1[1]+ (dist + c) * n[1])+'" z="'+(lP + add)+'" />';
    str += '<p nr="7" x="'+(p2[0]+ (dist + c) * n[0])+'" y="'+(p2[1]+ (dist + c) * n[1])+'" z="'+(lP + add)+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalCeilingFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','6,7,8');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcWall');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','6_Fassadengerüst_Verputz-/Malergerüst');
    desiteAPI.setMaterialToObjects('ModelColor5',id);
    FWList.push([p1[0] + dist * n[0], p1[1] + dist * n[1], p2[0] + dist * n[0], p2[1] + dist * n[1], lP + add]);
    globalCeilingCounter = globalCeilingCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'6');
    linkDocuments(id,'7');
    linkDocuments(id,'8');
    return id;
}

//Konsole
function createGeometryFramework2(p1,p2,h1,h2,n,addProp,roof)
{
    var id = __internal__[14].txt + globalCeilingCounter;
    var dist = parseFloat(document.getElementById('FrameworkDistance').value);
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor6">';
    str += '<p nr="0" x="'+(p1[0])+'" y="'+(p1[1])+'" z="'+h1+'" />';
    str += '<p nr="1" x="'+(p2[0])+'" y="'+(p2[1])+'" z="'+h1+'" />';
    str += '<p nr="2" x="'+(p1[0] - 0.3 * n[0])+'" y="'+(p1[1] - 0.3 * n[1])+'" z="'+h1+'" />';
    str += '<p nr="3" x="'+(p2[0] - 0.3 * n[0])+'" y="'+(p2[1] - 0.3 * n[1])+'" z="'+h1+'" />';
    str += '<p nr="4" x="'+(p1[0])+'" y="'+(p1[1])+'" z="'+h2+'" />';
    str += '<p nr="5" x="'+(p2[0])+'" y="'+(p2[1])+'" z="'+h2+'" />';
    str += '<p nr="6" x="'+(p1[0] - 0.3 * n[0])+'" y="'+(p1[1] - 0.3 * n[1])+'" z="'+h2+'" />';
    str += '<p nr="7" x="'+(p2[0] - 0.3 * n[0])+'" y="'+(p2[1] - 0.3 * n[1])+'" z="'+h2+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalCeilingFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','9');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcWall');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','9_Innenkonsole_Fassadengerüst');
    desiteAPI.setMaterialToObjects('ModelColor6',id);
    FWList.push([p1[0] - 0.3 * n[0],p1[1] - 0.3 * n[1],p2[0] - 0.3 * n[0],p2[1] - 0.3 * n[1],h2]);
    globalCeilingCounter = globalCeilingCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'9');
    return id;
}


//Geländer
function createGeometryFramework3(p1,p2,h1,h2,n,addProp,roof)
{
    var id = __internal__[11].txt + globalCeilingCounter;
    var dist = parseFloat(document.getElementById('FrameworkDistance').value);
    var str = '<object3D ID="'+id+'" name="'+id+'" matID="ModelColor7">';
    str += '<p nr="0" x="'+(p1[0])+'" y="'+(p1[1])+'" z="'+h1+'" />';
    str += '<p nr="1" x="'+(p2[0])+'" y="'+(p2[1])+'" z="'+h1+'" />';
    str += '<p nr="2" x="'+(p1[0] - 0.05 * n[0])+'" y="'+(p1[1] - 0.05 * n[1])+'" z="'+h1+'" />';
    str += '<p nr="3" x="'+(p2[0] - 0.05 * n[0])+'" y="'+(p2[1] - 0.05 * n[1])+'" z="'+h1+'" />';
    str += '<p nr="4" x="'+(p1[0])+'" y="'+(p1[1])+'" z="'+h2+'" />';
    str += '<p nr="5" x="'+(p2[0])+'" y="'+(p2[1])+'" z="'+h2+'" />';
    str += '<p nr="6" x="'+(p1[0] - 0.05 * n[0])+'" y="'+(p1[1] - 0.05 * n[1])+'" z="'+h2+'" />';
    str += '<p nr="7" x="'+(p2[0] - 0.05 * n[0])+'" y="'+(p2[1] - 0.05 * n[1])+'" z="'+h2+'" />';
    str += '<t nr="0" p1="0" p2="2" p3="1" />';
    str += '<t nr="1" p1="1" p2="2" p3="3" />';
    str += '<t nr="2" p1="0" p2="1" p3="4" />';
    str += '<t nr="3" p1="1" p2="5" p3="4" />';
    str += '<t nr="4" p1="0" p2="4" p3="2" />';
    str += '<t nr="5" p1="2" p2="4" p3="6" />';
    str += '<t nr="6" p1="1" p2="3" p3="7" />';
    str += '<t nr="7" p1="1" p2="7" p3="5" />';
    str += '<t nr="8" p1="3" p2="2" p3="7" />';
    str += '<t nr="9" p1="2" p2="6" p3="7" />';
    str += '<t nr="10" p1="4" p2="5" p3="6" />';
    str += '<t nr="11" p1="5" p2="7" p3="6" />';
    str += '</object3D>';
    desiteAPI.createObjectFromXml(globalCeilingFolder,str);
    desiteAPI.setPropertyValue(id,'Documents','xs:string','10');
    desiteAPI.setPropertyValue(id,'ifcType','xs:string','IfcWall');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Typ','xs:string','6_Fassadengerüst_Verputz-/Malergerüst');
    desiteAPI.setPropertyValue(id,'Absturzsicherung_Suva:Innengeländer','xs:boolean',true);
    desiteAPI.setMaterialToObjects('ModelColor7',id);
    FWList.push([p1[0] - 0.05 * n[0],p1[1] - 0.05 * n[1],p2[0] - 0.05 * n[0],p2[1] - 0.05 * n[1],h2]);
    globalCeilingCounter = globalCeilingCounter + 1;
    __createdGeo__.push(id);
    linkDocuments(id,'10');
    return id;
}

function linkDocuments(id,addProp)
{
    var p = addProp.split(',');
    for(var i = 0; i < p.length; i++)
    {
        var erg = parseInt(p[i])-1;
        desiteAPI.setLinkedObjects(__dokuList__[erg],id);
    }
}