function calculateFramework()
{
    var RT = desiteAPI.getRootContainerList('DIMENSIONS');
    frameworkID = [];
    __frameworkList__ = [];
    for(var k = 0; k < RT.length; k++)
    {
        var p = desiteAPI.getContainedElements(RT[k],0);
        var __frameworkListpH__ = [];
        var normalList = [];
        var fID = [];
        numFloor = 0;
        for(var i = 0; i < p.length; i++)
        {
            var w = desiteAPI.getPropertyValue(p[i],'createdMeasurementViaScript','xs:boolean');
            if(!w || w == "undefined")
            {
                continue;
            }
            numFloor++;
            var a = desiteAPI.getAsJSON(p[i]);
            var triangle = [];
            var points = [];
            for(var j = 0; j < a.triangleList.length; j = j + 3)
            {
                triangle.push([a.triangleList[j],a.triangleList[j+1],a.triangleList[j+2]]);
            }
            for(var j = 0; j < a.vertexList.length; j = j + 3)
            {
                points.push([a.vertexList[j],a.vertexList[j+1],a.vertexList[j+2]]);
            }
            // Check longest xy Edge
            var maxEdge = 0;
            var p1;
            var p2;
            for(var j = 0; j < triangle.length; j++)
            {
                var cP1 = [points[triangle[j][0]][0],points[triangle[j][0]][1]];
                var cP2 = [points[triangle[j][1]][0],points[triangle[j][1]][1]];
                var cP3 = [points[triangle[j][2]][0],points[triangle[j][2]][1]];
                var e1 = norm2_2D([cP2[0]-cP1[0], cP2[1] - cP1[1]]);
                var e2 = norm2_2D([cP3[0]-cP2[0], cP3[1] - cP2[1]]);
                var e3 = norm2_2D([cP1[0]-cP3[0], cP1[1] - cP3[1]]);
                if (e1 > maxEdge)
                {
                    p1 = cP1;
                    p2 = cP2;
                    maxEdge = e1;
                }
                if (e2 > maxEdge)
                {
                    p1 = cP2;
                    p2 = cP3;
                    maxEdge = e2;
                }
                if (e3 > maxEdge)
                {
                    p1 = cP3;
                    p2 = cP1;
                    maxEdge = e3;
                }
            }
            var dir = [p2[0] - p1[0],p2[1] - p1[1],0.0];
            var dir_norm = norm2_2D(dir);
            normalList.push([-dir[1]/dir_norm,dir[0]/dir_norm]);
            __frameworkListpH__.push([[p1[0],p1[1]],[p2[0],p2[1]]]);
            fID.push(p[i]);
        }
        for(var i = 0; i < __frameworkListpH__.length; i++)
        {
            var con = false;
            for(var j=0; j < __frameworkList__.length; j++)
            {
                var v1x = __frameworkList__[j][0][0];
                var v1y = __frameworkList__[j][0][1];
                var v2x = __frameworkList__[j][1][0];
                var v2y = __frameworkList__[j][1][1];
                var u1x = __frameworkListpH__[i][0][0];
                var u1y = __frameworkListpH__[i][0][1];
                var u2x = __frameworkListpH__[i][1][0];
                var u2y = __frameworkListpH__[i][1][1];
                if(Math.abs(v1x-u1x) < 10e-6 && Math.abs(v1y-u1y) < 10e-6)
                {
                    if(Math.abs(v2x-u2x)<10e-6 && Math.abs(v2y-u2y)<10e-6)
                    {
                        con = true;
                    }
                }
                else if(Math.abs(v1x-u2x) < 10e-6 && Math.abs(v1y-u2y) < 10e-6)
                {
                    if(Math.abs(v2x-u1x) < 10e-6 && Math.abs(v2y-u1y) < 10e-6)
                    {
                        con = true;
                    }
                }
            }
            if(con == false)
            {
                __frameworkList__.push(__frameworkListpH__[i]);
                __frameworkListNormal__.push(normalList[i]);
                frameworkID.push(fID[i]);
            }
        }
        
    }
}

function setFramework()
{
    if(desiteAPI.getModelListByName('DIMENSIONS') == '')
    {
        globalModelID = createModel('DIMENSIONS');
    }
    var RT = desiteAPI.getRootContainerList('DIMENSIONS');
    var erg = desiteAPI.getPickedFaces();
    if(!erg.hasOwnProperty('faces'))
    {
        return 0;
    }
    if(erg.faces.length > 0)
    {
        var counter = 0;
        for(var i=0;i<erg.faces.length;i++)
        {
            var vert = erg.faces[i].vertices;
            for(var j=0; j< erg.faces[i].triangles.length;j++)
            {
                var name = 'Tri' + (numFloor);
                var v1 = vert[erg.faces[i].triangles[j][0]];
                var v2 = vert[erg.faces[i].triangles[j][1]];
                var v3 = vert[erg.faces[i].triangles[j][2]];
                var str = '<object3D ID="'+name+'" name="'+name+'" matID="ModelColor3">';
                str += '<p nr="0" x="'+v1[0]+'" y="'+v1[1]+'" z="'+v1[2]+'" />';
                str += '<p nr="1" x="'+v2[0]+'" y="'+v2[1]+'" z="'+v2[2]+'" />';
                str += '<p nr="2" x="'+v3[0]+'" y="'+v3[1]+'" z="'+v3[2]+'" />';
                str += '<t nr="0" p1="0" p2="1" p3="2" />';
                str += '</object3D>';
                var id = desiteAPI.createObjectFromXml(RT,str);
                desiteAPI.setPropertyValue(id,'createdMeasurementViaScript','xs:boolean',true);
                numFloor++;
            }
        }
    }
}

function getFramework()
{
    calculateFramework();
}

function showFramework()
{
    var RT = desiteAPI.getRootContainerList('DIMENSIONS');
    var str = '';
    for(var k = 0; k < RT.length; k++)
    {
        var p = desiteAPI.getContainedElements(RT[k],0);
        for(var i = 0; i < p.length; i++)
        {
            var w = desiteAPI.getPropertyValue(p[i],'createdMeasurementViaScript','xs:boolean');
            if(!w || w == "undefined")
            {
                continue;
            }
            if( i + 1 == p.length)
            {
                str += p[i];
            }
            else
            {
                str += p[i] + ';';
            }
        }
    }
    if(str.charAt(str.length-1) == ';')
    {
        str = str.substring(str.length-1);
    }
    desiteAPI.selectElements(str,'true');
}

function removeFramework()
{
    __frameworkList__ = [];
    frameworkID = [];
}