function checkLiftOpening4D(process)
{
    for(var a = 0; a < __currentLiftOpeningData__.length; a++)
    {
        var polygons = getPolygonsCurrentLift(a);
        var lP_z = getLowestPointZ(a);
        for(var i = 0; i < polygons.length; i++)
        {
            for(var j = 0; j < polygons[i].length; j++)
            {
                var p1;
                var p2;
                if (j == polygons[i].length - 1)
                {
                    p1 = polygons[i][j];
                    p2 = polygons[i][0];
                } 
                else
                {
                    p1 = polygons[i][j];
                    p2 = polygons[i][j+1];
                }
                var dir = [p2[0] - p1[0], p2[1] - p1[1], p2[2] - p1[2]];
                var dir_length_int = parseInt(Math.sqrt(dir[0] * dir[0] + dir[1] * dir[1] + dir[2] * dir[2]) / __dep__[2].value);
                var n;
                var n1 = [-dir[1],dir[0]];
                var n2 = [dir[1],-dir[0]];
                var n1_check = 0;
                var pCheck = [(p2[0] + p1[0]) / 2, (p2[1] + p1[1]) / 2];
                for(var k = 0; k < polygons[i].length; k++)
                {
                    if (k != j)
                    {
                        var pC1;
                        var pC2;
                        if (k == polygons[i].length - 1)
                        {
                            pC1 = polygons[i][k];
                            pC2 = polygons[i][0];
                        } 
                        else
                        {
                            pC1 = polygons[i][k];
                            pC2 = polygons[i][k+1];
                        }
                        var cDir = [pC2[0] - pC1[0], pC2[1] - pC1[1], pC2[2] - pC2[2]];
                        var erg1 = rayLineIntersection_2D(pCheck,n1,pC1,cDir);
                        n1_check = n1_check + erg1;
                        if(!(n1_check % 2))
                        {
                            n = n1;
                        }
                        else
                        {
                            n = n2;
                        }
                    }
                }
                var n_length = norm2_2D(n);
                n[0] = n[0] / n_length;
                n[1] = n[1] / n_length;
                n.push(0);
                var pC1_result = 0;
                var pC2_result = 0;
                var tS = false;
                if(dir_length_int == 0)
                {
                    dir_length_int = 1
                    tS = true;
                }
                for(var k = 0; k < dir_length_int; k++)
                {
                    var pC1_result = 0;
                    var pC2_result = 0;
                    var pC1;
                    if(tS)
                    {
                        pC1 = [p1[0],p1[1],p1[2]];
                        pC2 = [p2[0],p2[1],p2[2]];
                    }
                    else
                    {
                        if(dir_length_int == 0)
                        {
                            pC1 = [p1[0],p1[1],p1[2]]; 
                        } 
                        else
                        {
                            pC1 = [p1[0] + (k/dir_length_int) * dir[0],p1[1] + (k/dir_length_int) * dir[1],p1[2] + (k/dir_length_int) * dir[2]];
                        }
                        var pC2;
                        if(k+1 > dir_length_int)
                        {
                            pC2 = [p2[0],p2[1],p2[2]];
                        }
                        else
                        {
                            pC2 = [p1[0] + ((k+1)/dir_length_int) * dir[0],p1[1] + ((k+1)/dir_length_int) * dir[1], p1[2] + ((k+1)/dir_length_int) * dir[2]];
                        }
                        var dist1 = [pC1[0] - pC2[0], pC1[1] - pC2[1], pC1[2] - pC2[2]]; 
                        if(norm2_3D(dist1) < 10e-9)
                        {
                            continue;
                        }
                    }
                    //Check free Edge
                    var n_div = [n[0],n[1],n[2]];
                    if(i > 0)
                    {
                        n_div[0] = -n[0];
                        n_div[1] = -n[1];
                    }
                    for(var l = 0; l < __globalLiftData__.length;l++)
                    {
                        pC1_result = 0;
                        pC2_result = 0;
                        if(__globalLiftData__[l][4][2] <= p1[2] && __globalLiftData__[l][4][5] >= p1[2])
                        {
                            for(var m = 0; m < __globalLiftData__[l][2].length; m++)
                            {
                                var cP0 = __globalLiftData__[l][3][__globalLiftData__[l][2][m][0]];
                                var cP1 = __globalLiftData__[l][3][__globalLiftData__[l][2][m][1]];
                                var cP2 = __globalLiftData__[l][3][__globalLiftData__[l][2][m][2]];

                                var e1 = rayTriangleIntersection(cP0,cP1,cP2,pC1,n_div);
                                var e2 = rayTriangleIntersection(cP0,cP1,cP2,pC2,n_div);
                                if(e1 != null)
                                {
                                    if(e1 >= (-1) * __dep__[19].value && e1 <= 0)
                                    {
                                        pC1_result = 3;
                                    }    
                                }

                                if(e2 != null)
                                {
                                    if(e2 >= (-1) * __dep__[19].value && e2 <= 0)
                                    {
                                        pC2_result = 3;
                                    }
                                }
                                if(pC1_result == 3 || pC2_result == 3)
                                {
                                    e = createGeometryCeiling4(pC1,pC2,lP_z,n_div);
                                    desiteAPI.setLinkedObjects(process,e);
                                    break;
                                }
                            }
                            if(pC1_result == 3 || pC2_result == 3)
                            {
                                break;
                            }
                        }
                    }
                }
            }
        }
    }
}

function getLowestPointZ(a)
{
    return __currentLiftOpeningData__[a][4][2];
}

function getPolygonsCurrentLift(x)
{
    var topFace = 0;
    for(var i = 0; i < __currentLiftOpeningData__[x][1].length; i++)
    {
        if (Math.abs(normalVectorZ(__currentLiftOpeningData__[x][1][i][0], __currentLiftOpeningData__[x][2], __currentLiftOpeningData__[x][3]) -1) < 10e-9)
        {
            topFace = i;
        }
    }
    var topTriangle = [];
    for(var i = 0; i< __currentLiftOpeningData__[x][1][topFace].length; i++)
    {
        topTriangle.push(__currentLiftOpeningData__[x][2][__currentLiftOpeningData__[x][1][topFace][i]]);
    }
    var edgeList = [];
    for(var i = 0; i < topTriangle.length; i++)
    {
        edgeList.push([topTriangle[i][0],topTriangle[i][1]]);
        edgeList.push([topTriangle[i][1],topTriangle[i][2]]);
        edgeList.push([topTriangle[i][2],topTriangle[i][0]]);
    }
    var l = edgeList.length;
    for(var i = 0; i < l - 1; i++)
    {
        for( var j = i + 1; j < l; j++)
        {
            if((edgeList[i][0] == edgeList[j][1] && edgeList[i][1] == edgeList[j][0]) || (edgeList[i][0] == edgeList[j][0] && edgeList[i][1] == edgeList[j][1]))
            {
                edgeList.splice(j,1);
                edgeList.splice(i,1);
                l = l - 2;
                j = i;
            }
        }
    }
    var polyList = [];
    for(var i = 0; i < edgeList.length; i++)
    {
        polyList.push(0);
    }
    var counter = 1;
    var c = 0;
    var polygonPointList = [];
    for(var i = 0; i < polyList.length; i++)
    {
        if(!polyList[i])
        {
            var pList = [];
            polyList[i] = counter;
            var fP = true;
            var close = false;
            c = i;
            while(!close)
            {
                for(var j = 0; j < edgeList.length; j++)
                {
                    if(j != c && !polyList[j])
                    {
                        if(edgeList[c][0] == edgeList[j][0])
                        {
                            if(fP)
                            {
                                pList.push(edgeList[c][1]);
                                fP = false;
                            }
                            pList.push(edgeList[c][0]);
                            polyList[j] = counter;
                            c = j;
                            break;
                        }
                        else if(edgeList[c][0] == edgeList[j][1])
                        {
                            if(fP)
                            {
                                pList.push(edgeList[c][1]);
                                fP = false;
                            }
                            pList.push(edgeList[c][0]);
                            polyList[j] = counter;
                            c = j;
                            break;
                        }
                        else if (edgeList[c][1] == edgeList[j][0])
						{
							if (fP)
							{
								pList.push(edgeList[c][0]);
								fP = false;
							}
							pList.push(edgeList[c][1]);
							polyList[j] = counter;
							c = j;
							break;
						}
						else if (edgeList[c][1] == edgeList[j][1])
						{
							if (fP)
							{
								pList.push(edgeList[c][0]);
								fP = false;
							}
							pList.push(edgeList[c][1]);
							polyList[j] = counter;
							c = j;
							break;
						}
                    }
                    if(j == edgeList.length - 1)
                    {
                        close = true;
                    }
                }
            }
            polygonPointList.push(pList);
            counter++;
        }
    }
    var outerPolygon = 0;
    var outerArea = 0;
    var area = [];
    for(var i = 0; i < polygonPointList.length; i++)
    {
        var cArea = 0.0;
        for(var j = 0; j < polygonPointList[i].length; j++)
        {
            cArea += (__currentLiftOpeningData__[x][3][polygonPointList[i][j]][0] - __currentLiftOpeningData__[x][3][polygonPointList[i][(j + 1) % polygonPointList[i].length]][0]) * (__currentLiftOpeningData__[x][3][polygonPointList[i][j]][1] + __currentLiftOpeningData__[x][3][polygonPointList[i][(j + 1) % polygonPointList[i].length]][1]);
        }
        area.push(Math.abs(cArea)/2.0);
        if(area[i] > outerArea)
        {
            outerArea = area[i];
            outerPolygon = i;
        }
    }
    erg = [];
    erg.push([]);
    counter = 1;
    for(var i = 0; i < polygonPointList[outerPolygon].length; i++)
    {
        erg[0].push((__currentLiftOpeningData__[x][3][polygonPointList[outerPolygon][i]]));
    }
    for(var i = 0; i < polygonPointList.length; i++)
    {
        if(i != outerPolygon)
        {
            erg.push([]);
            for(var j = 0; j < polygonPointList[i].length; j++)
            {
                erg[counter].push((__currentLiftOpeningData__[x][3][polygonPointList[i][j]]));
            }
            counter++;
        }
    }
    return erg;
}