function cross(p1,p2)
{
    return erg = [p1[1] * p2[2] - p1[2] * p2[1],p1[2] * p2[0] - p1[0] * p2[2], p1[0] * p2[1] - p1[1] * p2[0]];
}

function dot_2D(v1,v2)
{
    return erg = v1[0] * v2[0] + v1[1] * v2[1];
}

function dot_3D(v1,v2)
{
    return erg = v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
}

function norm2_3D(p1)
{
    return Math.sqrt(p1[0] * p1[0] + p1[1] * p1[1] + p1[2]* p1[2]);
}

function norm2_2D(p1)
{
    return Math.sqrt(p1[0] * p1[0] + p1[1] * p1[1]);
}

function rayLineIntersection_2D(p1,v1,p2,v2)
{
    var pH = v2[1] * v1[0] - v2[0] * v1[1];
    if(Math.abs(pH) < 10e-9)
    {
        return 0;
    }
    else
    {
        if (Math.abs(v1[0]) > 0)
        {
            var a1 = p1[1] * v1[0] - p1[0] * v1[1];
            var a2 = p2[0] * v1[1] - p2[1] * v1[0];
            var r = (a1 + a2) / pH;
            if (r >= -10e-5 && r <= (1 + 10e-5))
            {
                var t = (p2[0] + r * v2[0] - p1[0]) / v1[0];
                if( t >= 0)
                {
                    return 1;
                }    
            }
            return 0;
        }
        else
        {
            var r = (p1[0] - p2[0]) / v2[0];
            if ( r >= -10e-5 && r <= (1 + 10e-5))
            {
                var t = (p2[1] + r * v2[1] - p1[1]) / v1[1];
                if(t >= 0)
                {
                    return 1;
                }
            }
            return 0;
        }
    }
}

function rayLineDistIntersection2D(p1,v1,p2,v2,dist)
{
    var pH = v2[1] * v1[0] - v2[0] * v1[1];
    if(Math.abs(pH) < 10e-9)
    {
        return 0;
    }
    else
    {
        if (Math.abs(v1[0]) > 10e-5)
        {
            var a1 = p1[1] * v1[0] - p1[0] * v1[1];
            var a2 = p2[0] * v1[1] - p2[1] * v1[0];
            var r = (a1 + a2) / pH;
            if (r >-10e-5 && r <= (1 + 10e-5))
            {
                var t = (p2[0] + r * v2[0] - p1[0]) / v1[0];
                if( t >= -10e-5 && t <= dist)
                {
                    return 1;
                }    
            }
            return 0;
        }
        else
        {
            var r = (p1[0] - p2[0]) / v2[0];
            if ( r >= -10e-5 && r <= (1 + 10e-5))
            {
                var t = (p2[1] + r * v2[1] - p1[1]) / v1[1];
                if(t >= -10e-5 && t <= dist)
                {
                    return 1;
                }
            }
            return 0;
        }
    }
}

function pointLineIntersection2D(p,p1,p2)
{
    var dir = [p2[0] - p1[0], p2[1] - p1[1]];
    if(Math.abs(dir[0]) > 10e-5)
    {
        var r = (p[0] - p1[0]) / dir[0];
        if(Math.abs(dir[1]) > 10e-5)
        {
            var t = (p[1] - p1[1]) / dir[1];
            if(Math.abs(r-t) < 10e-4 && ((r >= -10e-4 && r <= (1 + 10e-4)) || (t >= -10e-4 && t <= (1 + 10e-4))))
            {
                return true;
            }
        }
        else
        {
            var d = p[1] - p1[1];
            if(r >= -10e-5 && r <= (1 + 10e-4) && Math.abs(d) < 10e-4)
            {
                return true;
            }
        }    
    }
    else
    {
        var d = p[0] - p1[0];
        var t = (p[1] - p1[1]) / dir[1];
        if(t >= 10e-5 && t <= (1 + 10e-5) && Math.abs(d) < 10e-5)
        {
            return true;
        }
    }
    return false;
}

function pointTriangleIntersection(p1,p2,p3,c)
{
    var v1 = [p2[0] - p1[0], p2[1] - p1[1], p2[2] - p1[2]];
    var v2 = [p3[0] - p1[0], p3[1] - p1[1], p3[2] - p1[2]];
    
    var v3 = [c[0] - p1[0], c[1] - p1[1], c[2] - p1[2]];
    var v4 = [p2[0] - c[0], p2[1] - c[1], p2[2] - c[2]];
    var v5 = [p3[0] - c[0], p3[1] - c[1], p3[2] - c[2]];

    var cross1 = [v1[1] * v2[2] - v1[2] * v2[1],v1[2] * v2[0] - v1[0] * v2[2],v1[0] * v2[1] - v1[1] * v2[0]];

    var cross2 = [v1[1] * v3[2] - v1[2] * v3[1],v1[2] * v3[0] - v1[0] * v3[2],v1[0] * v3[1] - v1[1] * v3[0]];

    var cross3 = [v3[1] * v2[2] - v3[2] * v2[1],v3[2] * v2[0] - v3[0] * v2[2],v3[0] * v2[1] - v3[1] * v2[0]];

    var cross4 = [v4[1] * v5[2] - v4[2] * v5[1],v4[2] * v5[0] - v4[0] * v5[2],v4[0] * v5[1] - v4[1] * v5[0]];

    var a = norm2_3D(cross1);
    var b = norm2_3D(cross2);
    var c = norm2_3D(cross3);
    var d = norm2_3D(cross4);
    if(b+c+d-a<10e-9)
    {
        return true;
    }
    return false;

}

function triangleLineIntersection(p1,p2,p3,c,v)
{
    var e1 = [p2[0] - p1[0], p2[1] - p1[1], p2[2] - p1[2]];
    var e2 = [p3[0] - p1[0], p3[1] - p1[1], p3[2] - p1[2]];
    var h = [v[1] * e2[2] - v[2] * e2[1], v[2] * e2[0] - v[0] * e2[2], v[0] * e2[1] - v[1] * e2[0]];
    var a = e1[0] * h[0] + e1[1] * h[1] + e1[2] * h[2];
    if(Math.abs(a) < 10e-9)
    {
        return false;
    }
    var f = 1.0 / a;
    var s = [c[0] - p1[0],c[1] - p1[1],c[2] - p1[2]];
    var u = f * (s[0] * h[0] + s[1] * h[1] + s[2] * h[2]);
    if( u < 10e-5 || u > 1)
    {
        return false;
    }
    var q = [s[1] * e1[2] - s[2] * e1[1], s[2] * e1[0] - s[0] * e1[2], s[0] * e1[1] - s[1] * e1[0]];
    var i = f * (v[0] * q[0] + v[1] * q[1] + v[2] * q[2]);
    if ( i < 10e-5 || i > 1)
    {
        return false;
    }
    var t = f * (e2[0] * q[0] + e2[1] * q[1] + e2[2] * q[2]);

    if (t > 1)
    {
        return false;
    }
    return true;
}

function rayTriangleIntersection(p1,p2,p3,c,v)
{
    var e1 = [p2[0] - p1[0], p2[1] - p1[1], p2[2] - p1[2]];
    var e2 = [p3[0] - p1[0], p3[1] - p1[1], p3[2] - p1[2]];
    var h = [v[1] * e2[2] - v[2] * e2[1], v[2] * e2[0] - v[0] * e2[2], v[0] * e2[1] - v[1] * e2[0]];
    var a = e1[0] * h[0] + e1[1] * h[1] + e1[2] * h[2];
    if(Math.abs(a) < 10e-6)
    {
        return null;
    }
    var f = 1.0 / a;
    var s = [c[0] - p1[0],c[1] - p1[1],c[2] - p1[2]];
    var u = f * (s[0] * h[0] + s[1] * h[1] + s[2] * h[2]);
    if( u < 10e-5 || u > 1)
    {
        return null;
    }
    var q = [s[1] * e1[2] - s[2] * e1[1], s[2] * e1[0] - s[0] * e1[2], s[0] * e1[1] - s[1] * e1[0]];
    var i = f * (v[0] * q[0] + v[1] * q[1] + v[2] * q[2]);
    if ( i < 10e-5|| i + u > 1)
    {
        return null;
    }
    var t = f * (e2[0] * q[0] + e2[1] * q[1] + e2[2] * q[2]);
    return t;
}

function calcAreaBB(BB)
{
    var dx = 0;
    var dy = 0;
    for( var i = 1; i < BB.length; i++)
    {
        if(Math.abs(BB[0][0] - BB[i][0]) > dx)
        {
            dx = Math.abs(BB[0][0] - BB[i][0]);
        }
        if(Math.abs(BB[0][1] - BB[i][1]) > dy)
        {
            dy = Math.abs(BB[0][1] - BB[i][1]);
        }
    }
    return dx * dy;
}

function rayLineIntersection_2D_Distance(p1,v1,p2,v2)
{
    var pH = v2[1] * v1[0] - v2[0] * v1[1];
    if(Math.abs(pH) < 10e-9)
    {
        return -1;
    }
    else
    {
        if (Math.abs(v1[0]) > 0)
        {
            var a1 = p1[1] * v1[0] - p1[0] * v1[1];
            var a2 = p2[0] * v1[1] - p2[1] * v1[0];
            var r = (a1 + a2) / pH;
            if (r >= -10e-5 && r <= (1 + 10e-5))
            {
                var t = (p2[0] + r * v2[0] - p1[0]) / v1[0];
                if( t >= 0)
                {
                    return t;
                }    
            }
            return -1;
        }
        else
        {
            var r = (p1[0] - p2[0]) / v2[0];
            if ( r >= -10e-5 && r <= (1 + 10e-5))
            {
                var t = (p2[1] + r * v2[1] - p1[1]) / v1[1];
                if(t >= 0)
                {
                    return t;
                }
            }
            return -1;
        }
    }
}

function isOrtho(v,n,delta)
{
    var value = dot_2D(v,n) / (norm2_2D(v) * norm2_2D(n));
    var degree = Math.acos(value) * 180 / Math.PI;
    if(degree > 90-delta && degree < 90 +delta)
    {
        return true;
    }

    return false;
}