function getRoof()
{
    var x = desiteAPI.getSelectedElements();
    for(var i = 0; i < x.length; i++)
    {
        if(roofID.indexOf(x[i]) == -1)
        {
            roofID.push(x[i]);
        }
    }
    document.getElementById('idAvaRoof').value = '('+roofID.length+')';
}

function showRoof()
{
    var str = '';
    for(var i = 0; i < roofID.length; i++)
    {
        if( i + 1 == roofID.length)
        {
            str += roofID[i];
        }
        else
        {
            str += roofID[i] + ';';
        }
    }
    desiteAPI.selectElements(str,'true');
}

function removeRoof()
{
    roofID = [];
    document.getElementById('idAvaRoof').value = '(0)';
}

function checkFolderRoof()
{
    if(globalModelID == '')
    {
        globalModelID = createModel(globalModelName);
    }
    var RT = desiteAPI.getRootContainerList(globalModelName);
    var str = '<container ID="'+ globalRoofFolder +'" name="'+ globalRoofFolder +'" />';
    desiteAPI.createObjectFromXml(RT,str);
}

function checkRoof4D(process)
{
    for(var a = 0; a < __currentRoofData__.length; a++)
    {
        var degree = 0;
        degree = degreeOfFace(a);
        var polygons = getCurrentPolygonsRoof(a);
        var cb1 = true;
        for(var b = 0; b < polygons.length; b++)
        {
            var slabArea = 0;
            var localArea = 0;
            var inner = false;
            for(var i = 0; i < polygons[b].length; i++)
            {
                var polyBB = getPolygonsBB(polygons[b][i]);
                var openingLiftDone = false;
                var zmin = polyBB[0][2];
                var zmax = polyBB[0][2];
                for(var f = 1; f < polyBB.length; f++)
                {
                    if(zmin > polyBB[f][2])
                    {
                        zmin = polyBB[f][2];
                    }
                    if(zmax < polyBB[f][2])
                    {
                        zmax = polyBB[f][2];
                    }
                }
                if(i == 0)
                {
                    slabArea = calcAreaBB(polyBB);
                }
                else
                {
                    localArea = calcAreaBB(polyBB);
                    inner = true;
                }
                for(var j = 0; j < polygons[b][i].length; j++)
                {
                    var p1;
                    var p2;
                    if (j == polygons[b][i].length - 1)
                    {
                        p1 = polygons[b][i][j];
                        p2 = polygons[b][i][0];
                    } 
                    else
                    {
                        p1 = polygons[b][i][j];
                        p2 = polygons[b][i][j+1];
                    }
                    var dir = [p2[0] - p1[0], p2[1] - p1[1], p2[2] - p1[2]];
                    var dir_length_int = parseInt(Math.sqrt(dir[0] * dir[0] + dir[1] * dir[1] + dir[2] * dir[2]) / __dep__[2].value);
                    var n;
                    var n1 = [-dir[1],dir[0]];
                    var n2 = [dir[1],-dir[0]];
                    var n1_check = 0;
                    var pCheck = [(p2[0] + p1[0]) / 2, (p2[1] + p1[1]) / 2];
                    for(var k = 0; k < polygons[b][i].length; k++)
                    {
                        if (k != j)
                        {
                            var pC1;
                            var pC2;
                            if (k == polygons[b][i].length - 1)
                            {
                                pC1 = polygons[b][i][k];
                                pC2 = polygons[b][i][0];
                            } 
                            else
                            {
                                pC1 = polygons[b][i][k];
                                pC2 = polygons[b][i][k+1];
                            }
                            var cDir = [pC2[0] - pC1[0], pC2[1] - pC1[1], pC2[2] - pC2[2]];
                            var erg1 = rayLineIntersection_2D(pCheck,n1,pC1,cDir);
                            n1_check = n1_check + erg1;
                            if(!(n1_check % 2))
                            {
                                n = n1;
                            }
                            else
                            {
                                n = n2;
                            }
                        }
                    }
                    var n_length = norm2_2D(n);
                    n[0] = n[0] / n_length;
                    n[1] = n[1] / n_length;
                    n.push(0);
                    var n_div = [n[0],n[1],n[2]];
                    if(i > 0)
                    {
                        n_div[0] = -n[0];
                        n_div[1] = -n[1];
                    }
                    var pC1_result = 0;
                    var pC2_result = 0;
                    var addProp = '';
                    for(var k = 0; k <= dir_length_int; k++)
                    {
                        var pC1_result = 0;
                        var pC2_result = 0;
                        addProp = '';
                        var pC1;
                        if(dir_length_int == 0)
                        {
                            pC1 = [p1[0],p1[1],p1[2]];
                        }
                        else
                        {
                            pC1 = [p1[0] + (k/dir_length_int) * dir[0],p1[1] + (k/dir_length_int) * dir[1],p1[2] + (k/dir_length_int) * dir[2]];
                        }
                        var pC2;
                        if(k+1 >= dir_length_int)
                        {
                            pC2 = [p2[0],p2[1],p2[2]];
                        }
                        else
                        {
                            pC2 = [p1[0] + ((k+1)/dir_length_int) * dir[0],p1[1] + ((k+1)/dir_length_int) * dir[1], p1[2] + ((k+1)/dir_length_int) * dir[2]];
                        }
                        if(polygons.length > 1)
                        {
                            if(Math.abs(zmin - zmax) > 0.5)
                            {
                                if(Math.abs(pC1[2] - pC2[2]) < 10e-4 && Math.abs(__currentRoofData__[a][4][5] - pC1[2]) < 10e-4)
                                {
                                continue;
                                }
                            }
                        }
                        var dist1 = [pC1[0] - pC2[0], pC1[1] - pC2[1], pC1[2] - pC2[2]]; 
                        if(norm2_3D(dist1) < 10e-9)
                        {
                            continue;
                        }
                        //Free Edge
                        if(document.getElementById('cb1').checked && cb1)
                        {
                            var nnp = [0,0,0];
                            dist = calculateCurrentMaxDistance(0,0,pC1,pC2,nnp,__currentRoofData__[a][0],inner);
                            if (dist > __dep__[4].value)
                            {
                                cb1 = false;
                            }
                        }
                        if(!(pC1_result == 1 && pC2_result == 1))
                        {
                            erg = checkContact(p1,p2,pC1,pC2,n_div,pC1_result,pC2_result,__legacyGeometryData__,__currentRoofData__[a][0], __dep__[3].value);
                            if(pC1_result == 0)
                            {
                                pC1_result = erg[0];
                            }
                            if(pC2_result == 0)
                            {
                                pC2_result = erg[1];
                            }
                        }
                        if(!(pC1_result == 1 && pC2_result == 1))
                        {
                            erg = checkContact(p1,p2,pC1,pC2,n_div,pC1_result,pC2_result,__legacySlabData__,__currentRoofData__[a][0], __dep__[3].value);
                            if(pC1_result == 0)
                            {
                                pC1_result = erg[0];
                            }
                            if(pC2_result == 0)
                            {
                                pC2_result = erg[1];
                            }
                        }
                        if(!(pC1_result == 1 && pC2_result == 1))
                        {
                            erg = checkContact(p1,p2,pC1,pC2,n_div,pC1_result,pC2_result,__legacyRoofData__,__currentRoofData__[a][0], __dep__[3].value);
                            if(pC1_result == 0)
                            {
                                pC1_result = erg[0];
                            }
                            if(pC2_result == 0)
                            {
                                pC2_result = erg[1];
                            }
                        }
                        if(!(pC1_result == 1 && pC2_result == 1))
                        {
                            erg = checkContact(p1,p2,pC1,pC2,n_div,pC1_result,pC2_result,__globalDTMData__,__currentRoofData__[a][0], __dep__[3].value);
                            if(pC1_result == 0)
                            {
                                pC1_result = erg[0];
                            }
                            if(pC2_result == 0)
                            {
                                pC2_result = erg[1];
                            }
                        }
                        if(i > 0 && localArea < __dep__[14].value && (pC1_result == 0 || pC2_result == 0))
                        {
                            var e;
                            if((degree *180 / Math.PI)  < __dep__[12].value && !openingLiftDone)
                            {
                                e = createGeometryRoof17(polyBB[0],polyBB[1],polyBB[2],polyBB[3],polyBB[4],polyBB[5],polyBB[6],polyBB[7],'1,2,3,17,19,20');
                                desiteAPI.setLinkedObjects(process,e);
                            }
                            else if((degree *180 / Math.PI)  < __dep__[13].value && !openingLiftDone)
                            {
                                e = createGeometryRoof17(polyBB[0],polyBB[1],polyBB[2],polyBB[3],polyBB[4],polyBB[5],polyBB[6],polyBB[7],'1,3,17,19,20');
                                desiteAPI.setLinkedObjects(process,e);
                            }
                            else if(!openingLiftDone)
                            {
                                e = createGeometryRoof17(polyBB[0],polyBB[1],polyBB[2],polyBB[3],polyBB[4],polyBB[5],polyBB[6],polyBB[7],'17,19,20');
                                desiteAPI.setLinkedObjects(process,e);
                            }                
                            openingLiftDone = true;
                            break;
                        }
                        //Check height
                        var dist = -1;
                        if(pC1_result == 0 || pC2_result == 0)
                        {
                            dist = calculateMaxCurrentDistanceRoof(pC1_result,pC2_result,pC1,pC2,n_div,a,inner);
                        }
                        var vario = 0;
                        if(inner)
                        {
                            vario = __dep__[5].value;
                        }
                        else
                        {
                            vario = __dep__[15].value;
                        }
                        if(dist > vario)
                        {
                            var p = frameworkCheck(pC1,pC2,n_div,__dep__[9].value);
                            if(p[0] > -1)
                            {
                                var e;
                                if(Math.abs(dir[2]) < __dep__[20].value)
                                {
                                    if((degree *180 / Math.PI)  < __dep__[12].value)
                                    {
                                        if(document.getElementById('cb2').checked)
                                        {
                                            e = createGeometryRoof11(pC1,pC2,n_div,'11',p[1]);    
                                        }
                                        else
                                        {
                                            e = createGeometryRoof11(pC1,pC2,n_div,'11',0);
                                        }
                                        desiteAPI.setLinkedObjects(process,e);
                                    }
                                    else if((degree *180 / Math.PI)  < __dep__[13].value)
                                    {
                                        if(document.getElementById('cb2').checked)
                                        {
                                            e = createGeometryRoof12(pC1,pC2,n_div,'12',p[1]);    
                                        }
                                        else
                                        {
                                            e = createGeometryRoof12(pC1,pC2,n_div,'12',0);
                                        }
                                        desiteAPI.setLinkedObjects(process,e);
                                    }
                                    else
                                    {
                                        if(document.getElementById('cb2').checked)
                                        {
                                            e = createGeometryRoof13(pC1,pC2,n_div,'13',p[1]);    
                                        }
                                        else
                                        {
                                            e = createGeometryRoof13(pC1,pC2,n_div,'13',0);
                                        }
                                        desiteAPI.setLinkedObjects(process,e);
                                    }
                                }
                                else{
                                    if((degree *180 / Math.PI)  < __dep__[12].value)
                                    {
                                        if(document.getElementById('cb2').checked)
                                        {
                                            e = createGeometryRoof11(pC1,pC2,n_div,'11',p[1]);    
                                        }
                                        else
                                        {
                                            e = createGeometryRoof11(pC1,pC2,n_div,'11',0);
                                        }
                                        desiteAPI.setLinkedObjects(process,e);
                                    }
                                    else if((degree *180 / Math.PI)  < __dep__[13].value)
                                    {
                                        if(document.getElementById('cb2').checked)
                                        {
                                            e = createGeometryRoof15(pC1,pC2,n_div,'14,15',p[1]);    
                                        }
                                        else
                                        {
                                            e = createGeometryRoof15(pC1,pC2,n_div,'14,15',0);
                                        }
                                        desiteAPI.setLinkedObjects(process,e);
                                    }
                                    else
                                    {
                                        if(document.getElementById('cb2').checked)
                                        {
                                            e = createGeometryRoof15(pC1,pC2,n_div,'14,15',p[1]);    
                                        }
                                        else
                                        {
                                            e = createGeometryRoof15(pC1,pC2,n_div,'14,15',0);
                                        }
                                        desiteAPI.setLinkedObjects(process,e);
                                    }
                                }
                                addProp = '6,7,8';
                                var res = checkForExistingFrameWork(pC1,pC2,n_div,__dep__[9].value)
                                if(res > -1)
                                {
                                    dist = res;
                                }
                                if(document.getElementById('cb2').checked)
                                {
                                    e = createGeometryFramework1(pC1,pC2,dist,n_div,p[1],true);
                                }
                                else
                                {
                                    e = createGeometryFramework1(pC1,pC2,dist,n_div,0,true);
                                }
                                desiteAPI.setLinkedObjects(process,e);
                                var fD = parseFloat(document.getElementById('FrameworkDistance').value);
                                var pL1 = [];
                                var pL2 = [];
                                if(document.getElementById('cb2').checked)
                                {
                                    pL1 = [pC1[0] + n_div[0] * (fD + p[1]),pC1[1] + n_div[1] * (fD + p[1]),pC1[2] + n_div[2] * (fD + p[1])];
                                    pL2 = [pC2[0] + n_div[0] * (fD + p[1]),pC2[1] + n_div[1] * (fD + p[1]),pC2[2] + n_div[2] * (fD + p[1])];
                                }
                                else
                                {
                                    pL1 = [pC1[0] + n_div[0] * (fD),pC1[1] + n_div[1] * (fD),pC1[2] + n_div[2] * (fD)];
                                    pL2 = [pC2[0] + n_div[0] * (fD),pC2[1] + n_div[1] * (fD),pC2[2] + n_div[2] * (fD)];
                                }
                                e = [];
                                if(fD > __dep__[21].value)
                                {
                                    e = checkCurrentFrameworkConsole(pL1,pL2,dist,n_div,p1,p2,true,addProp,true);
                                }
                                else
                                {
                                    e = checkCurrentFrameworkConsole(pL1,pL2,dist,n_div,p1,p2,false,addProp,true);
                                }
                                for(var f = 0; f < e.length; f++)
                                {
                                    desiteAPI.setLinkedObjects(process,e[f]);
                                }
                            }
                            else
                            {
                                var e;
                                addProp += '1,2,3';
                                e = createGeometryRoof1(pC1,pC2,n,addProp);
                                desiteAPI.setLinkedObjects(process,e);
                            }
                        }
                    }
                }
            }
        }
        if(!cb1)
        {
            var bottomTriangle = getBottomFaceRoof(a);
            var lP = getLowestPoint(a,bottomTriangle);
            for(var w = 0; w < bottomTriangle.length; w++)
            {
                var t1 = createGeometryRoof20(__currentRoofData__[a][3][bottomTriangle[w][0]],__currentRoofData__[a][3][bottomTriangle[w][1]],__currentRoofData__[a][3][bottomTriangle[w][2]],lP,'19,20');
                desiteAPI.setLinkedObjects(process,t1);
            }
        }
    }
}

function getLowestPoint(a,triLst)
{
    var lP = 1000000;
    for(var w = 0; w < triLst.length; w++)
    {
        var p1 = __currentRoofData__[a][3][triLst[w][0]];
        var p2 = __currentRoofData__[a][3][triLst[w][1]];
        var p3 = __currentRoofData__[a][3][triLst[w][2]];
        if(p1[2] < lP)
        {
            lP = p1[2];
        }
        if(p2[2] < lP)
        {
            lP = p2[2];
        }
        if(p3[2] < lP)
        {
            lP = p3[2];
        }
    }
    return lP;
}

function getBottomFaceRoof(x)
{
    var bottomFace = [];
    for(var i = 0; i < __currentRoofData__[x][1].length; i++)
    {
        if (normalVectorZ(__currentRoofData__[x][1][i][0], __currentRoofData__[x][2], __currentRoofData__[x][3]) < 0 && getAreaofFace(__currentRoofData__[x][1][i],__currentRoofData__[x][2],__currentRoofData__[x][3]) > __dep__[16].value)
        {
            bottomFace.push(i);
        }
    }
    var bottomTriangle = [];
    for(var a = 0; a < bottomFace.length; a++)
    {   
        for(var i = 0; i< __currentRoofData__[x][1][bottomFace[a]].length; i++)
        {
            bottomTriangle.push(__currentRoofData__[x][2][__currentRoofData__[x][1][bottomFace[a]][i]]);
        }
    }
    return bottomTriangle;
}

function calculateMaxCurrentDistanceRoof(pC1_result,pC2_result,pC1,pC2,n,a,inner)
{
    var res = 0;
    var d = -1;
    
    if(pC1_result == 0)
    {
        var vario = 0;
        if(inner)
        {
            vario = __dep__[5].value;
        }
        else
        {
            vario = __dep__[7].value;
        }
        var pC4 = [pC1[0] + vario * n[0], pC1[1] + vario * n[1], pC1[2] + vario * n[2]];
        var n_4 = [0,0,-1];
        var erg = 0;
        erg = maxDistanceData(pC4,n_4,__legacyGeometryData__,__currentRoofData__[a][0]);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__legacySlabData__,__currentRoofData__[a][0]);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__legacyRoofData__,__currentRoofData__[a][0]);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        if(__globalDTMData__.length == 0)
        {
            erg = pC4[2];
        }
        else
        {
            erg = maxDistanceData(pC4,n_4,__globalDTMData__,__currentRoofData__[a][0]);
        }
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__currentSlabData__,__currentRoofData__[a][0]);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
    } 
    res = d;
    d = -1;
    if(pC2_result == 0)
    {
        var vario = 0;
        if(inner)
        {
            vario = __dep__[5].value;
        }
        else
        {
            vario = __dep__[7].value;
        }
        var pC4 = [pC2[0] + vario * n[0], pC2[1] + vario * n[1], pC2[2] + vario * n[2]];
        var n_4 = [0,0,-1];
        var erg = 0;
        erg = maxDistanceData(pC4,n_4,__legacyGeometryData__,__currentRoofData__[a][0]);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__legacySlabData__,__currentRoofData__[a][0]);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__legacyRoofData__,__currentRoofData__[a][0]);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        if(__globalDTMData__.length == 0)
        {
            erg = pC4[2];
        }
        else
        {
            erg = maxDistanceData(pC4,n_4,__globalDTMData__,__currentRoofData__[a][0]);
        }
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
        erg = maxDistanceData(pC4,n_4,__currentSlabData__,__currentRoofData__[a][0]);
        if((d < 0 && erg > 0) || (d > erg && erg > 0))
        {
            d = erg;
        }
    }
    if(d>res)
    {
        res = d;
    }
    return res;
}

function degreeOfFace(x)
{
    for(var i = 0; i < __currentRoofData__[x][1].length; i++)
    {
        if (normalVectorZ(__currentRoofData__[x][1][i][0], __currentRoofData__[x][2], __currentRoofData__[x][3]) > 0)
        {
            return Math.acos(normalVectorZ(__currentRoofData__[x][1][i][0], __currentRoofData__[x][2], __currentRoofData__[x][3]));
        }
    }
}

function getAreaofFace(face,triangleList,points)
{
    var sum = 0;
    for(var i = 0; i < face.length; i++)
    {
        var p1 = points[triangleList[face[i]][0]];
        var p2 = points[triangleList[face[i]][1]];
        var p3 = points[triangleList[face[i]][2]];   
        var d1 = [p2[0] - p1[0],p2[1] - p1[1],p2[2] - p1[2]];

        var d2 = [p3[0] - p2[0],p3[1] - p2[1],p3[2] - p2[2]];
        var v = cross(d1,d2);

        sum += 0.5 * norm2_3D(v);
    }
    return sum;
}

function getCurrentPolygonsRoof(x)
{
    var topFace = [];
    for(var i = 0; i < __currentRoofData__[x][1].length; i++)
    {
        if (normalVectorZ(__currentRoofData__[x][1][i][0], __currentRoofData__[x][2], __currentRoofData__[x][3]) > 0 && getAreaofFace(__currentRoofData__[x][1][i],__currentRoofData__[x][2],__currentRoofData__[x][3]) > __dep__[16].value)
        {
            topFace.push(i);
        }
    }
    var erg = [];
    for(var a = 0; a < topFace.length; a++)
    {
        var topTriangle = [];
        for(var i = 0; i< __currentRoofData__[x][1][topFace[a]].length; i++)
        {
            topTriangle.push(__currentRoofData__[x][2][__currentRoofData__[x][1][topFace[a]][i]]);
        }
        var edgeList = [];
        for(var i = 0; i < topTriangle.length; i++)
        {
            edgeList.push([topTriangle[i][0],topTriangle[i][1]]);
            edgeList.push([topTriangle[i][1],topTriangle[i][2]]);
            edgeList.push([topTriangle[i][2],topTriangle[i][0]]);
        }
        var l = edgeList.length;
        for(var i = 0; i < l - 1; i++)
        {
            for( var j = i + 1; j < l; j++)
            {
                if((edgeList[i][0] == edgeList[j][1] && edgeList[i][1] == edgeList[j][0]) || (edgeList[i][0] == edgeList[j][0] && edgeList[i][1] == edgeList[j][1]))
                {
                    edgeList.splice(j,1);
                    edgeList.splice(i,1);
                    l = l - 2;
                    j = i;
                }
            }
        }
        var polyList = [];
        for(var i = 0; i < edgeList.length; i++)
        {
            polyList.push(0);
        }
        var t = true;
        var counter = 1;
        var c = 0;
        var polygonPointList = [];
        for(var i = 0; i < polyList.length; i++)
        {
            if(!polyList[i])
            {
                var pList = [];
                polyList[i] = counter;
                var fP = true;
                var close = false;
                c = i;
                while(!close)
                {
                    for(var j = 0; j < edgeList.length; j++)
                    {
                        if(j != c && !polyList[j])
                        {
                            if(edgeList[c][0] == edgeList[j][0])
                            {
                                if(fP)
                                {
                                    pList.push(edgeList[c][1]);
                                    fP = false;
                                }
                                pList.push(edgeList[c][0]);
                                polyList[j] = counter;
                                c = j;
                                break;
                            }
                            else if(edgeList[c][0] == edgeList[j][1])
                            {
                                if(fP)
                                {
                                    pList.push(edgeList[c][1]);
                                    fP = false;
                                }
                                pList.push(edgeList[c][0]);
                                polyList[j] = counter;
                                c = j;
                                break;
                            }
                            else if (edgeList[c][1] == edgeList[j][0])
                            {
                                if (fP)
                                {
                                    pList.push(edgeList[c][0]);
                                    fP = false;
                                }
                                pList.push(edgeList[c][1]);
                                polyList[j] = counter;
                                c = j;
                                break;
                            }
                            else if (edgeList[c][1] == edgeList[j][1])
                            {
                                if (fP)
                                {
                                    pList.push(edgeList[c][0]);
                                    fP = false;
                                }
                                pList.push(edgeList[c][1]);
                                polyList[j] = counter;
                                c = j;
                                break;
                            }
                        }
                        if(j == edgeList.length - 1)
                        {
                            close = true;
                        }
                    }
                }
                polygonPointList.push(pList);
                counter++;
            }
        }
        var outerPolygon = 0;
        var outerArea = 0;
        var area = [];
        for(var i = 0; i < polygonPointList.length; i++)
        {
            var cArea = 0.0;
            for(var j = 0; j < polygonPointList[i].length; j++)
            {
                cArea += (__currentRoofData__[x][3][polygonPointList[i][j]][0] - __currentRoofData__[x][3][polygonPointList[i][(j + 1) % polygonPointList[i].length]][0]) * (__currentRoofData__[x][3][polygonPointList[i][j]][1] + __currentRoofData__[x][3][polygonPointList[i][(j + 1) % polygonPointList[i].length]][1]);
            }
            area.push(Math.abs(cArea)/2.0);
            if(area[i] > outerArea)
            {
                outerArea = area[i];
                outerPolygon = i;
            }
        }
        erg.push([]);
        erg[a].push([]);
        counter = 1;
        for(var i = 0; i < polygonPointList[outerPolygon].length; i++)
        {
            erg[a][0].push((__currentRoofData__[x][3][polygonPointList[outerPolygon][i]]));
        }
        
        for(var i = 0; i < polygonPointList.length; i++)
        {
            if(i != outerPolygon)
            {
                erg[a].push([]);
                for(var j = 0; j < polygonPointList[i].length; j++)
                {
                    erg[a][counter].push((__currentRoofData__[x][3][polygonPointList[i][j]]));
                }
                counter++;
            }
        }
    }
    return erg;
}